/*
  sudokutablewidget.h
  Project: masudoku
  Platform: Fremantle (maemo5)
  Author: Petri Kultanen pete@petnetti.net
  Last Edit: 3.6.2010
*/
#ifndef SUDOKUTABLEWIDGET_H
#define SUDOKUTABLEWIDGET_H

#include <QWidget>
class CSudokuTable;
class QPaintEvent;
class QMouseEvent;
class QString;
class SudokuSettings;
class SudokuTableWidget : public QWidget
{
    Q_OBJECT
public:
    SudokuTableWidget();
    void setTable(CSudokuTable *aTable);
	void setSettings(SudokuSettings* aSettings){iSettings = aSettings;};
    void paintEvent(QPaintEvent *aEvent);
    void mousePressEvent(QMouseEvent * aEvent);
    void setSelectedCoordinates(int aX,int aY);
signals:
    void slotSelected(int aX,int aY);

private:
    CSudokuTable *iTable;
    int iSelectedX; // used for drawing mark to cell that is being edited.
    int iSelectedY;
	SudokuSettings* iSettings;
};

#endif // SUDOKUTABLEWIDGET_H
