/*
sudokusettings.cpp
Project: masudoku
Platform: Fremantle (maemo5)
Author: Petri Kultanen pete@petnetti.net
Last Edit: 3.6.2010
*/
#include "sudokusettings.h"
#include "sudokutable.h"
#include <QColor>
#include <QObject>
#include <QFile>
#include <QDataStream>
/* ---------------------------------------------------------------------------
* Constructor
*/
SudokuSettings::SudokuSettings()
{
	iBackgroundColor = Qt::black;
	iFontColor = Qt::white;
	iWrongNumberFontColor = Qt::red;
	iGridColor = Qt::white;
	iFullGridColor = Qt::green;
	iPracMode = false;	
	iShowSolveButton = false;
}
/* ---------------------------------------------------------------------------
* load settings from file
*/
bool SudokuSettings::loadSettings(CSudokuTable* aSudokuTable)
{
	QFile data("/home/user/MyDocs/.masudokusettings.txt");
	if (data.open(QFile::ReadOnly)) {
		QDataStream in(&data);
		in >> iBackgroundColor;
		in >> iFontColor;
		in >> iWrongNumberFontColor;
		in >> iGridColor;
		in >> iFullGridColor;
		in >> iPracMode;
		in >> iShowSolveButton;
		aSudokuTable->clearTable();
		//Load normal numbers
		for(int i=0;i<9;i++)
		{
			for(int j=0;j<9;j++)
			{
				int a;
				in >> a;
				aSudokuTable->setNumL(a,i,j);
			}
		}
		//Load memory numbers
		for(int i=0;i<9;i++)
		{
			for(int j=0;j<9;j++)
			{
				qint32 a;
				in >> a;
				aSudokuTable->setMemoryDataNum(a,i,j);
			}
		}			
		
	}
	else
	{
		return false;
	}
	return true;
}
/* ---------------------------------------------------------------------------
* save settings to file
*/	
bool SudokuSettings::saveSettings(CSudokuTable* aSudokuTable)
{
	QFile data("/home/user/MyDocs/.masudokusettings.txt");
	if (data.open(QFile::WriteOnly)) {
		QDataStream out(&data);
		out << iBackgroundColor;
		out << iFontColor;
		out << iWrongNumberFontColor;
		out << iGridColor;
		out << iFullGridColor;
		out << iPracMode;
		out << iShowSolveButton;
		
		for(int i=0;i<9;i++)
		{
			for(int j=0;j<9;j++)
			{
				int a = aSudokuTable->getNumL(i,j);
				out << a;
			}
		}
		for(int i=0;i<9;i++)
		{
			for(int j=0;j<9;j++)
			{
				qint32 a = aSudokuTable->getMemoryDataNum(i,j);
				out << a;
			}
		}			
	}
	else
	{
		return false;
	}
	return true;
}


void SudokuSettings::setBackgroundColor(QColor aColor){iBackgroundColor=aColor;}
void SudokuSettings::setFontColor(QColor aColor){iFontColor=aColor; }

void SudokuSettings::setWrongNumberFontColor(QColor aColor){iWrongNumberFontColor=aColor; }
void SudokuSettings::setGridColor(QColor aColor){iGridColor=aColor; }
void SudokuSettings::setFullGridColor(QColor aColor){iFullGridColor=aColor; }
void SudokuSettings::setPractiseMode(bool aMode) {iPracMode = aMode;}
void SudokuSettings::setShowSolveButton(bool aMode) {iShowSolveButton = aMode;}

/* ---------------------------------------------------------------------------
* return Background color
*/	
QColor SudokuSettings::getBackgroundColor(){return iBackgroundColor;}
QColor SudokuSettings::getFontColor(){return iFontColor;}
QColor SudokuSettings::getWrongNumberFontColor(){return iWrongNumberFontColor;} 
QColor SudokuSettings::getGridColor(){return iGridColor;}
QColor SudokuSettings::getFullGridColor(){return iFullGridColor;}
bool SudokuSettings::getPractiseMode(){return iPracMode;}
bool SudokuSettings::getShowSolveButton(){return iShowSolveButton;}
