#ifndef APPLICATION_H
#define APPLICATION_H

#include <QApplication>

#include "bookmark.h"

class MainWindow;

class Application : public QApplication
{
    Q_OBJECT
public:
    explicit Application(int & argc, char ** argv);
    ~Application();

    static Application& Instance() {
        Application *pApp = dynamic_cast<Application *>(QApplication::instance());
        if ( pApp ) return *pApp;
        qFatal("Invalid Application instance");
        return *pApp; // will crash?
    }

#ifdef Q_WS_MAEMO_5
    bool registerService();
#endif
    int execute();

    void saveSettings();
    void visitUrl(QString url, bool fakeUserAgent);
    MainWindow* newWindow();

private:
    int loadSettings();

public:
    QList<Bookmark> m_bookmarks;

    // settings
    bool m_fakeUserAgent;
    int m_orientation;

private:
    MainWindow  *m_pMainWindow;

signals:

public slots:
    // dbus
    void start();
    void open(const QString &url, bool fakeAgent);

    void aboutMacuco();
};

#endif // APPLICATION_H
