/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "bookmark.h"

#include <QList>

Bookmark::Bookmark()
{
    m_title = QString::null;
    m_url = QString::null;
}

Bookmark::Bookmark(QString title, QString url) :
    m_url(url),
    m_title(title)

{
}

Bookmark::~Bookmark() {
}

QString Bookmark::title() const {
    return m_title;
}

QString Bookmark::url() const {
    return m_url;
}

void Bookmark::setTitle(QString value) {
    m_title = value;
}

void Bookmark::setUrl(QString value) {
    m_url =value;
}

void Bookmark::registerMeataType() {
    qRegisterMetaType<Bookmark>("Bookmark");
    qRegisterMetaTypeStreamOperators<Bookmark>("Bookmark");

    qRegisterMetaType< QList<Bookmark> >("QList<Bookmark>");
    qRegisterMetaTypeStreamOperators< QList<Bookmark> >("QList<Bookmark>");
}

bool Bookmark::isNull() {
    return m_url.isNull() || m_title.isNull();
}

bool Bookmark::operator==(const Bookmark& other) {
    return m_title==other.m_title;
}

// serialization
QT_BEGIN_NAMESPACE
QDataStream &operator<<(QDataStream &out, const Bookmark &bookmark) {
    out << bookmark.title();
    out << bookmark.url();

    return out;
}
QDataStream &operator>>(QDataStream &in, Bookmark &bookmark) {
    QString str;
    in >> str; bookmark.setTitle(str);
    in >> str; bookmark.setUrl(str);

    return in;
}
QT_END_NAMESPACE
// end: serialization


