/*
 * tangle-show-actor-action.h
 *
 * This file is part of Tangle Toolkit - A graphical widget library based on Clutter Toolkit
 *
 * (c) 2010 Henrik Hedberg <henrik.hedberg@innologies.fi>
 *
 */

#ifndef __TANGLE_SHOW_ACTOR_ACTION_H__
#define __TANGLE_SHOW_ACTOR_ACTION_H__

#include "tangle-action.h"

#define TANGLE_TYPE_SHOW_ACTOR_ACTION (tangle_show_actor_action_get_type())
#define TANGLE_SHOW_ACTOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), TANGLE_TYPE_SHOW_ACTOR_ACTION, TangleShowActorAction))
#define TANGLE_IS_SHOW_ACTOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), TANGLE_TYPE_SHOW_ACTOR_ACTION))
#define TANGLE_SHOW_ACTOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), TANGLE_TYPE_SHOW_ACTOR_ACTION, TangleShowActorActionClass))
#define TANGLE_IS_SHOW_ACTOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), TANGLE_TYPE_SHOW_ACTOR_ACTION))
#define TANGLE_SHOW_ACTOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS((obj), TANGLE_TYPE_SHOW_ACTOR_ACTION, TangleShowActorActionClass))

typedef struct _TangleShowActorActionPrivate TangleShowActorActionPrivate;

typedef struct _TangleShowActorAction {
	TangleAction parent_instance;
	TangleShowActorActionPrivate* priv;
} TangleShowActorAction;

typedef struct _TangleShowActorActionClass {
	TangleActionClass parent_class;
} TangleShowActorActionClass;

GType tangle_show_actor_action_get_type(void) G_GNUC_CONST;

TangleAction* tangle_show_actor_action_new(void);

ClutterActor* tangle_show_actor_action_get_actor(TangleShowActorAction* action);
void tangle_show_actor_action_set_actor(TangleShowActorAction* action, ClutterActor* actor);
gboolean tangle_show_actor_action_get_hide_others(TangleShowActorAction* action);
void tangle_show_actor_action_set_hide_others(TangleShowActorAction* action, gboolean hide_others);

#endif
