/*
 * This file is part of the Liquid project.
 * It is header file of class Filters, which realizes additional
 * graphic effects and Ice tool for editor.
 *
 * Copyright (C) 2009 Kirpichonock K.N. <kirpiche@cs.karelia.ru>
 * Copyright (C) 2009 Volkov A.A. <volkov@cs.karelia.ru>
 * Copyright (C) 2009 Dmitriev V.V. <vdmitrie@cs.karelia.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

//! Filters Module.
/*!
  This module realizes additional graphic effects (filters) and
  Ice tool (blur of region) for graphic editor.
*/

#ifndef FILTERS_H
#define FILTERS_H

#include <QImage>
#include <QColor>

class Filters
{
public:
    //! A constructor.
    Filters();
    //! Implements blur of all workspace
    QImage blur(QImage *image);
    //! Implements blur of region (Ice tool)
    QImage blurCircle(int i, int j, int r, QImage *image);

private:
    //! Checks boundaries of blur
    void checking(int i, int j, QImage *image);
    //! Implements blur of neighbourhood of pixel (i,j)
    QRgb qrgb(int i, int j, QImage *image);
    //! Makes kernel for gaussian blur
    /*!
      \param rad - radius of blur
    */
    float* makeKernel(float rad);
    float *m_kernel;
    float m_sum;
    int radius; /*!< Radius of blur. */
    int upperBorder; /*!< Upper border of blur. */
    int lowerBorder; /*!< Lower border of blur. */
    int leftBorder; /*!< Left border of blur. */
    int rightBorder; /*!< Right border of blur. */
    float sum;
    int imageWidth; /*!< Width of image. */
    int imageHeight; /*!< Height of image. */
};

#endif // FILTERS_H
