/*
 *  lenscover reminder statusbar plugin.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _LENS_COVER_REMINDER_H
#define _LENS_COVER_REMINDER_H

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define TYPE_LENS_COVER_STATUS_PLUGIN (lens_cover_status_plugin_get_type())

#define LENS_COVER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								  TYPE_LENS_COVER_STATUS_PLUGIN, LensCoverStatusPlugin))

#define LENS_COVER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST((klass), \
								       TYPE_LENS_COVER_STATUS_PLUGIN, StatusPluginClass))

#define IS_LENS_COVER_STATUS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
								     TYPE_LENS_COVER_STATUS_PLUGIN))

#define IS_LENS_COVER_STATUS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
									   TYPE_LENS_COVER_STATUS_PLUGIN))


typedef struct _LensCoverStatusPlugin LensCoverStatusPlugin;
typedef struct _LensCoverStatusPluginClass LensCoverStatusPluginClass;
typedef struct _LensCoverStatusPluginPrivate LensCoverStatusPluginPrivate;

struct _LensCoverStatusPlugin
{
  HDStatusMenuItem parent;
  LensCoverStatusPluginPrivate* priv;
};

struct _LensCoverStatusPluginClass
{
  HDStatusMenuItemClass parent;
};

GType lens_cover_status_plugin_get_type(void);

G_END_DECLS
#endif
