#include "test.h"
#include "../src/kmplayerplaylist.h"

int KMPlayer::connection_counter;

#define CREATE_DOCUMENT                                  \
        NodePtr doc = new Document ("foo");              \
        Node *n1 = new GenericURL (doc, "a.mp3");        \
        Node *n2 = new GenericURL (doc, "b.mp3");        \
        Node *n3 = new GenericURL (doc, "c.mp3");        \
        doc->appendChild (n1);                           \
        doc->appendChild (n2);                           \
        doc->appendChild (n3)

int main() {
    {
        TEST_INFO(Test add and remove on empty list);
        CREATE_DOCUMENT;
        ConnectionLink link;
        link.connect (doc.ptr (), MsgEventPostponed, n1);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        TEST_VERIFY (list->first ()->connecter.ptr () == n1);
        TEST_VERIFY (list->first ()->connectee == doc);
        link.disconnect ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test two additions and remove from front);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1;
        ConnectionLink link2;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        TEST_VERIFY (list->first ()->connecter.ptr () == n1);
        TEST_VERIFY (list->first ()->connectee == doc);
        link1.disconnect ();
        TEST_VERIFY (!link1.connection);
        TEST_VERIFY (list->first ()->connecter.ptr () == n2);
        TEST_VERIFY (list->first ()->connectee == doc);
        link2.disconnect ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test two additions and remove from back);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        TEST_VERIFY (list->first ()->next->connecter.ptr () == n2);
        link2.disconnect ();
        TEST_VERIFY (list->first ()->connecter.ptr () == n1);
        TEST_VERIFY (!list->first ()->next);
        TEST_VERIFY (list->first ()->connectee == doc);
        link1.disconnect ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test three additions and remove from middle);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        TEST_VERIFY (list->first ()->next->connecter.ptr () == n2);
        link2.disconnect ();
        TEST_VERIFY (list->first ()->next->connecter.ptr () == n3);
        link1.disconnect ();
        link3.disconnect ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test three additions and clears list);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        list->clear ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test single additions and clears list);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        list->clear ();
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!link1.connection);
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test clearing empty list);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        TEST_VERIFY (!list->first ());
        list->clear ();
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test three additions and iterating);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        Connection *c = list->first ();
        TEST_VERIFY (c->connecter.ptr () == n1);
        c = list->next ();
        TEST_VERIFY (c->connecter.ptr () == n2);
        c = list->next ();
        TEST_VERIFY (c->connecter.ptr () == n3);
        c = list->next ();
        TEST_VERIFY (!c);
        list->clear ();
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test iterating empty list);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        Connection *c = list->first ();
        TEST_VERIFY (!c);
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test iterating list with three deleting current);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        Connection *c = list->first ();
        TEST_VERIFY (c->connecter.ptr () == n1);
        link1.disconnect();
        c = list->next ();
        TEST_VERIFY (c->connecter.ptr () == n2);
        link2.disconnect();
        c = list->next ();
        TEST_VERIFY (c->connecter.ptr () == n3);
        link3.disconnect();
        c = list->next ();
        TEST_VERIFY (!c);
        list->clear ();
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test iterating list with three deleting next);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        Connection *c = list->first ();
        TEST_VERIFY (c->connecter.ptr () == n1);
        link2.disconnect();
        c = list->next ();
        TEST_VERIFY (c->connecter.ptr () == n3);
        c = list->next ();
        TEST_VERIFY (!c);
        list->clear ();
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test iterating list with three clearing after first);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionLink link1, link2, link3;
        link1.connect (doc.ptr (), MsgEventPostponed, n1);
        link2.connect (doc.ptr (), MsgEventPostponed, n2);
        link3.connect (doc.ptr (), MsgEventPostponed, n3);
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        Connection *c = list->first ();
        TEST_VERIFY (c->connecter.ptr () == n1);
        list->clear ();
        c = list->next ();
        TEST_VERIFY (!c);
        list->clear ();
        TEST_VERIFY (!connection_counter);
    }
    {
        TEST_INFO(Test auto delete when out of scope);
        connection_counter = 0;
        CREATE_DOCUMENT;
        ConnectionList *list = nodeMessageReceivers (doc, MsgEventPostponed);
        {
            ConnectionLink link1, link2, link3;
            link1.connect (doc.ptr (), MsgEventPostponed, n1);
            link2.connect (doc.ptr (), MsgEventPostponed, n2);
            link3.connect (doc.ptr (), MsgEventPostponed, n3);
            TEST_VERIFY (list->first ()->connecter.ptr () == n1);
        }
        TEST_VERIFY (!list->first ());
        TEST_VERIFY (!connection_counter);
    }
    return 0;
}
