/**sequencer.c is part of JamMo.
License: GPLv2, read more from COPYING

This file is for clutter based gui.
This is the sequencer.
 */
#include <tangle.h>
#include <glib-object.h>
#include "gamesmenu.h"
#include "config.h"
#include "../chum/chum.h"

ClutterActor* gamesmenu_group=NULL;
gboolean gamesmenu_is_ready = FALSE;

//button release animation
static gboolean buttonrelease_animate(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ClutterActor *button = CLUTTER_ACTOR(clutter_animation_get_object(CLUTTER_ANIMATION(actor)));
	clutter_actor_animate (button,          /* the actor to animate */
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			"scale-x", 1.0, /* final horizontal scaling factor */
			"scale-y", 1.0, /* final vertical scaling factor */
			NULL);
	return TRUE;
}


//button press animation
static gboolean buttonpress_animate(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	ClutterAnimation * anim = clutter_actor_animate(actor,
			CLUTTER_LINEAR, /* the easing mode */
			100,           /* the duration of the animation */
			"scale-gravity",CLUTTER_GRAVITY_CENTER,
			"scale-x", 0.80, /* final horizontal scaling factor */
			"scale-y", 0.80, /* final vertical scaling factor */
			NULL);
	g_signal_connect(anim, "completed", G_CALLBACK(buttonrelease_animate), NULL);
	return TRUE;
}

//return to startmenu
static gboolean goto_startmenu(ClutterActor *actor, ClutterEvent *event, gpointer data) {
	buttonpress_animate(actor, event, data);
	start_startmenu();
	return TRUE;
}

gboolean start_gamesmenu()
{
	tangle_actor_hide_animated(TANGLE_ACTOR(jammo_mentor_get_default()));
	printf("Starting gamesmenu\n");

	ClutterActor* mainview;
	ClutterActor* view;

	mainview = jammo_get_actor_by_id("main-views-widget"); //No drawing on stage anymore, use this.
	clutter_container_foreach(CLUTTER_CONTAINER(mainview), chum_hide_this_tangle_actor, NULL);
	
	view = tangle_view_new();   //This can be defined in json too.
	clutter_container_add(CLUTTER_CONTAINER(mainview), view, NULL);
	clutter_actor_show(view);
	
	ClutterActor* stage = view;

	gamesmenu_is_ready = FALSE;

	gamesmenu_group = config_get_configured_actor("gamesmenu","gamesmenu_view");
	clutter_actor_hide(gamesmenu_group);

	ClutterActor * start_composition_game = clutter_container_find_child_by_name(
			CLUTTER_CONTAINER(gamesmenu_group), "start_composition_game");

	ClutterActor * start_instrument_game = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(gamesmenu_group), "start_instrument_game");

	ClutterActor * start_singing_game = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(gamesmenu_group), "start_singing_game");


	ClutterActor * start_levelnumber = clutter_container_find_child_by_name(
						CLUTTER_CONTAINER(gamesmenu_group), "start_levelnumber");


	ClutterActor * home = clutter_container_find_child_by_name(
					CLUTTER_CONTAINER(gamesmenu_group), "home");

	ClutterActor * mentor = clutter_container_find_child_by_name(
				CLUTTER_CONTAINER(gamesmenu_group), "mentor");

	buttonpress_animate(CLUTTER_ACTOR(start_composition_game), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(start_instrument_game), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(start_singing_game), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(start_levelnumber), NULL, NULL);
	buttonpress_animate(CLUTTER_ACTOR(mentor), NULL, NULL);

	g_signal_connect(CLUTTER_ACTOR(start_composition_game), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);
	g_signal_connect(CLUTTER_ACTOR(start_instrument_game), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);
	g_signal_connect(CLUTTER_ACTOR(start_singing_game), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);
	g_signal_connect(CLUTTER_ACTOR(start_levelnumber), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);
	g_signal_connect(CLUTTER_ACTOR(home), "button_press_event", G_CALLBACK(goto_startmenu), NULL);
	g_signal_connect(CLUTTER_ACTOR(mentor), "button_press_event", G_CALLBACK(buttonpress_animate), NULL);


	clutter_actor_set_reactive(start_composition_game, TRUE);
	clutter_actor_set_reactive(start_instrument_game, TRUE);
	clutter_actor_set_reactive(start_singing_game, TRUE);
	clutter_actor_set_reactive(start_levelnumber, TRUE);
	clutter_actor_set_reactive(home, TRUE);
	clutter_actor_set_reactive(mentor, TRUE);

	clutter_container_add_actor(CLUTTER_CONTAINER(stage), CLUTTER_ACTOR(gamesmenu_group));

	printf("Gamesmenu initialization complete!\n");
	gamesmenu_is_ready = TRUE;
	clutter_actor_show (CLUTTER_ACTOR(gamesmenu_group));
	return FALSE;
}
gboolean gamesmenu_is_initialized()
{
	return gamesmenu_is_ready;
}
