/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected static final String RCSID = "$Id: StateEdit.java,v 1.6 1997/10/01 20:05:51 sandipc Exp $";
    protected StateEditable object;
    protected Hashtable<Object, Object> preState;
    protected Hashtable<Object, Object> postState;
    protected String undoRedoName;

    public StateEdit(StateEditable anObject) {
        this.init(anObject, null);
    }

    public StateEdit(StateEditable anObject, String name) {
        this.init(anObject, name);
    }

    protected void init(StateEditable anObject, String name) {
        this.object = anObject;
        this.preState = new Hashtable(11);
        this.object.storeState(this.preState);
        this.postState = null;
        this.undoRedoName = name;
    }

    public void end() {
        this.postState = new Hashtable(11);
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void removeRedundantState() {
        Vector<Object> uselessKeys = new Vector<Object>();
        Enumeration<Object> myKeys = this.preState.keys();
        while (myKeys.hasMoreElements()) {
            Object myKey = myKeys.nextElement();
            if (!this.postState.containsKey(myKey) || !this.postState.get(myKey).equals(this.preState.get(myKey))) continue;
            uselessKeys.addElement(myKey);
        }
        for (int i = uselessKeys.size() - 1; i >= 0; --i) {
            Object myKey = uselessKeys.elementAt(i);
            this.preState.remove(myKey);
            this.postState.remove(myKey);
        }
    }
}

