/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client.dispatch;

import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.client.dispatch.DispatchImpl;
import com.sun.xml.internal.ws.encoding.xml.XMLMessage;
import com.sun.xml.internal.ws.message.source.PayloadSourceMessage;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDispatch
extends DispatchImpl<DataSource> {
    public DataSourceDispatch(QName port, Service.Mode mode, WSServiceDelegate service, Tube pipe, BindingImpl binding, WSEndpointReference epr) {
        super(port, mode, service, pipe, binding, epr);
    }

    @Override
    Packet createPacket(DataSource arg) {
        switch (this.mode) {
            case PAYLOAD: {
                throw new IllegalArgumentException("DataSource use is not allowed in Service.Mode.PAYLOAD\n");
            }
            case MESSAGE: {
                return new Packet(XMLMessage.create(arg, this.binding));
            }
        }
        throw new WebServiceException("Unrecognized message mode");
    }

    @Override
    DataSource toReturnValue(Packet response) {
        Message message = response.getMessage();
        if (message instanceof XMLMessage.MessageDataSource) {
            XMLMessage.MessageDataSource hasDS = (XMLMessage.MessageDataSource)((Object)message);
            return hasDS.getDataSource();
        }
        if (message instanceof PayloadSourceMessage) {
            return XMLMessage.getDataSource(message, this.binding);
        }
        return null;
    }
}

