/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.CorbaConnectionCacheBase;
import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.InboundConnectionCache;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaAcceptor;
import java.util.ArrayList;
import java.util.Collection;

public class CorbaInboundConnectionCacheImpl
extends CorbaConnectionCacheBase
implements InboundConnectionCache {
    protected Collection connectionCache = new ArrayList();

    public CorbaInboundConnectionCacheImpl(ORB orb, Acceptor acceptor) {
        super(orb, acceptor.getConnectionCacheType(), ((CorbaAcceptor)acceptor).getMonitoringName());
    }

    public Connection get(Acceptor acceptor) {
        throw this.wrapper.methodShouldNotBeCalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Acceptor acceptor, Connection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".put: " + acceptor + " " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.add(connection);
            connection.setConnectionCache(this);
            this.dprintStatistics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Connection connection) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".remove: " + connection);
        }
        Object object = this.backingStore();
        synchronized (object) {
            this.connectionCache.remove(connection);
            this.dprintStatistics();
        }
    }

    public Collection values() {
        return this.connectionCache;
    }

    protected Object backingStore() {
        return this.connectionCache;
    }

    protected void registerWithMonitoring() {
        MonitoredObject thisMO;
        MonitoredObject inboundConnectionMO;
        MonitoredObject orbMO = this.orb.getMonitoringManager().getRootMonitoredObject();
        MonitoredObject connectionMO = orbMO.getChild("Connections");
        if (connectionMO == null) {
            connectionMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Connections", "Statistics on inbound/outbound connections");
            orbMO.addChild(connectionMO);
        }
        if ((inboundConnectionMO = connectionMO.getChild("Inbound")) == null) {
            inboundConnectionMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("Inbound", "Statistics on inbound connections");
            connectionMO.addChild(inboundConnectionMO);
        }
        if ((thisMO = inboundConnectionMO.getChild(this.getMonitoringName())) == null) {
            thisMO = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.getMonitoringName(), "Connection statistics");
            inboundConnectionMO.addChild(thisMO);
        }
        LongMonitoredAttributeBase attribute = new LongMonitoredAttributeBase("NumberOfConnections", "The total number of connections"){

            public Object getValue() {
                return new Long(CorbaInboundConnectionCacheImpl.this.numberOfConnections());
            }
        };
        thisMO.addAttribute(attribute);
        attribute = new LongMonitoredAttributeBase("NumberOfIdleConnections", "The number of idle connections"){

            public Object getValue() {
                return new Long(CorbaInboundConnectionCacheImpl.this.numberOfIdleConnections());
            }
        };
        thisMO.addAttribute(attribute);
        attribute = new LongMonitoredAttributeBase("NumberOfBusyConnections", "The number of busy connections"){

            public Object getValue() {
                return new Long(CorbaInboundConnectionCacheImpl.this.numberOfBusyConnections());
            }
        };
        thisMO.addAttribute(attribute);
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaInboundConnectionCacheImpl", msg);
    }
}

