/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Debug;
import sun.security.ssl.ExtensionType;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HelloExtension;

final class ServerNameExtension
extends HelloExtension {
    static final int NAME_HOST_NAME = 0;
    private List<ServerName> names = new ArrayList<ServerName>();

    ServerNameExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_SERVER_NAME);
        while (len > 0) {
            ServerName name = new ServerName(s);
            this.names.add(name);
            len -= name.length + 2;
        }
        if (len != 0) {
            throw new SSLProtocolException("Invalid server_name extension");
        }
    }

    int length() {
        throw new RuntimeException("not yet supported");
    }

    void send(HandshakeOutStream s) throws IOException {
        throw new RuntimeException("not yet supported");
    }

    public String toString() {
        return "Unsupported extension " + this.type + ", " + this.names.toString();
    }

    static class ServerName {
        final int length;
        final int type;
        final byte[] data;
        final String hostname;

        ServerName(HandshakeInStream s) throws IOException {
            this.length = s.getInt16();
            this.type = s.getInt8();
            this.data = s.getBytes16();
            this.hostname = this.type == 0 ? new String(this.data, "UTF8") : null;
        }

        public String toString() {
            if (this.type == 0) {
                return "host_name: " + this.hostname;
            }
            return "unknown-" + this.type + ": " + Debug.toString(this.data);
        }
    }
}

