/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class SynthContext {
    private static final Map contextMap = new HashMap();
    private JComponent component;
    private Region region;
    private SynthStyle style;
    private int state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SynthContext getContext(Class type, JComponent component, Region region, SynthStyle style, int state) {
        SynthContext context = null;
        Map map = contextMap;
        synchronized (map) {
            int size;
            List instances = (List)contextMap.get(type);
            if (instances != null && (size = instances.size()) > 0) {
                context = (SynthContext)instances.remove(size - 1);
            }
        }
        if (context == null) {
            try {
                context = (SynthContext)type.newInstance();
            }
            catch (IllegalAccessException iae) {
            }
            catch (InstantiationException ie) {
                // empty catch block
            }
        }
        context.reset(component, region, style, state);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseContext(SynthContext context) {
        Map map = contextMap;
        synchronized (map) {
            ArrayList<SynthContext> instances = (ArrayList<SynthContext>)contextMap.get(context.getClass());
            if (instances == null) {
                instances = new ArrayList<SynthContext>(5);
                contextMap.put(context.getClass(), instances);
            }
            instances.add(context);
        }
    }

    SynthContext() {
    }

    public SynthContext(JComponent component, Region region, SynthStyle style, int state) {
        if (component == null || region == null || style == null) {
            throw new NullPointerException("You must supply a non-null component, region and style");
        }
        this.reset(component, region, style, state);
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Region getRegion() {
        return this.region;
    }

    boolean isSubregion() {
        return this.getRegion().isSubregion();
    }

    void setStyle(SynthStyle style) {
        this.style = style;
    }

    public SynthStyle getStyle() {
        return this.style;
    }

    void setComponentState(int state) {
        this.state = state;
    }

    public int getComponentState() {
        return this.state;
    }

    void reset(JComponent component, Region region, SynthStyle style, int state) {
        this.component = component;
        this.region = region;
        this.style = style;
        this.state = state;
    }

    void dispose() {
        this.component = null;
        this.style = null;
        SynthContext.releaseContext(this);
    }

    SynthPainter getPainter() {
        SynthPainter painter = this.getStyle().getPainter(this);
        if (painter != null) {
            return painter;
        }
        return SynthPainter.NULL_PAINTER;
    }
}

