/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private SortedMap<String, Object> contents = new TreeMap<String, Object>();
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        int i;
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set<String> namesSet = compositeType.keySet();
        CompositeDataSupport.checkForNullElement(itemNames, "itemNames");
        CompositeDataSupport.checkForEmptyString(itemNames, "itemNames");
        if (itemValues == null || itemValues.length == 0) {
            throw new IllegalArgumentException("Argument itemValues[] cannot be null or empty.");
        }
        if (itemNames.length != itemValues.length) {
            throw new IllegalArgumentException("Array arguments itemNames[] and itemValues[] should be of same length (got " + itemNames.length + " and " + itemValues.length + ").");
        }
        if (itemNames.length != namesSet.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType (found " + itemNames.length + " elements in itemNames[] and itemValues[]," + " expecting " + namesSet.size() + " elements according to compositeType.");
        }
        if (!Arrays.asList(itemNames).containsAll(namesSet)) {
            throw new OpenDataException("Argument itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
        for (i = 0; i < itemValues.length; ++i) {
            OpenType<?> itemType = compositeType.getType(itemNames[i]);
            if (itemValues[i] == null || itemType.isValue(itemValues[i])) continue;
            throw new OpenDataException("Argument's element itemValues[" + i + "]=\"" + itemValues[i] + "\" is not a valid value for" + " this item (itemName=" + itemNames[i] + ",itemType=" + itemType + ").");
        }
        this.compositeType = compositeType;
        for (i = 0; i < itemNames.length; ++i) {
            this.contents.put(itemNames[i], itemValues[i]);
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map<String, ?> items) throws OpenDataException {
        this(compositeType, items == null ? null : items.keySet().toArray(new String[items.size()]), items == null ? null : items.values().toArray());
    }

    private static void checkForNullElement(Object[] arg, String argName) {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("Argument " + argName + "[] cannot be null or empty.");
        }
        for (int i = 0; i < arg.length; ++i) {
            if (arg[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] arg, String argName) {
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + argName + "[" + i + "] cannot be an empty string.");
        }
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public Object get(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("Argument key cannot be a null or empty String.");
        }
        if (!this.contents.containsKey(key.trim())) {
            throw new InvalidKeyException("Argument key=\"" + key.trim() + "\" is not an existing item name for this CompositeData instance.");
        }
        return this.contents.get(key.trim());
    }

    @Override
    public Object[] getAll(String[] keys) {
        if (keys == null || keys.length == 0) {
            return new Object[0];
        }
        Object[] results = new Object[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            results[i] = this.get(keys[i]);
        }
        return results;
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null || key.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    @Override
    public Collection<?> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompositeData)) {
            return false;
        }
        CompositeData other = (CompositeData)obj;
        if (!this.getCompositeType().equals(other.getCompositeType())) {
            return false;
        }
        if (this.contents.size() != other.values().size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
            Object e2;
            Object e1 = entry.getValue();
            if (e1 == (e2 = other.get(entry.getKey()))) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = e1.getClass().isArray() ? Arrays.deepEquals(new Object[]{e1}, new Object[]{e2}) : e1.equals(e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashcode = this.compositeType.hashCode();
        for (Object o : this.contents.values()) {
            if (o instanceof Object[]) {
                hashcode += Arrays.deepHashCode((Object[])o);
                continue;
            }
            if (o instanceof byte[]) {
                hashcode += Arrays.hashCode((byte[])o);
                continue;
            }
            if (o instanceof short[]) {
                hashcode += Arrays.hashCode((short[])o);
                continue;
            }
            if (o instanceof int[]) {
                hashcode += Arrays.hashCode((int[])o);
                continue;
            }
            if (o instanceof long[]) {
                hashcode += Arrays.hashCode((long[])o);
                continue;
            }
            if (o instanceof char[]) {
                hashcode += Arrays.hashCode((char[])o);
                continue;
            }
            if (o instanceof float[]) {
                hashcode += Arrays.hashCode((float[])o);
                continue;
            }
            if (o instanceof double[]) {
                hashcode += Arrays.hashCode((double[])o);
                continue;
            }
            if (o instanceof boolean[]) {
                hashcode += Arrays.hashCode((boolean[])o);
                continue;
            }
            if (o == null) continue;
            hashcode += o.hashCode();
        }
        return hashcode;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(compositeType=" + this.compositeType.toString() + ",contents=" + this.contents.toString() + ")";
    }
}

