/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.dom;

import com.sun.org.apache.xerces.internal.dom.AttrImpl;
import com.sun.org.apache.xerces.internal.dom.AttrNSImpl;
import com.sun.org.apache.xerces.internal.dom.CoreDocumentImpl;
import com.sun.org.apache.xerces.internal.dom.DOMMessageFormatter;
import com.sun.org.apache.xerces.internal.dom.ElementImpl;
import com.sun.org.apache.xerces.internal.dom.NamedNodeMapImpl;
import com.sun.org.apache.xerces.internal.dom.NodeImpl;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class AttributeMap
extends NamedNodeMapImpl {
    static final long serialVersionUID = 8872606282138665383L;

    protected AttributeMap(ElementImpl ownerNode, NamedNodeMapImpl defaults) {
        super(ownerNode);
        if (defaults != null) {
            this.cloneContent(defaults);
            if (this.nodes != null) {
                this.hasDefaults(true);
            }
        }
    }

    public Node setNamedItem(Node arg) throws DOMException {
        AttrImpl argn;
        boolean errCheck = this.ownerNode.ownerDocument().errorChecking;
        if (errCheck) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
            if (arg.getNodeType() != 2) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, msg);
            }
        }
        if ((argn = (AttrImpl)arg).isOwned()) {
            if (errCheck && argn.getOwnerElement() != this.ownerNode) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
                throw new DOMException(10, msg);
            }
            return arg;
        }
        argn.ownerNode = this.ownerNode;
        argn.isOwned(true);
        int i = this.findNamePoint(arg.getNodeName(), 0);
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
            previous.ownerNode = this.ownerNode.ownerDocument();
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = -1 - i;
            if (null == this.nodes) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(arg, i);
        }
        this.ownerNode.ownerDocument().setAttrNode(argn, previous);
        if (!argn.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        AttrImpl argn;
        boolean errCheck = this.ownerNode.ownerDocument().errorChecking;
        if (errCheck) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (arg.getOwnerDocument() != this.ownerNode.ownerDocument()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
            if (arg.getNodeType() != 2) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, msg);
            }
        }
        if ((argn = (AttrImpl)arg).isOwned()) {
            if (errCheck && argn.getOwnerElement() != this.ownerNode) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "INUSE_ATTRIBUTE_ERR", null);
                throw new DOMException(10, msg);
            }
            return arg;
        }
        argn.ownerNode = this.ownerNode;
        argn.isOwned(true);
        int i = this.findNamePoint(argn.getNamespaceURI(), argn.getLocalName());
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(arg, i);
            previous.ownerNode = this.ownerNode.ownerDocument();
            previous.isOwned(false);
            previous.isSpecified(true);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                previous = (AttrImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (null == this.nodes) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        this.ownerNode.ownerDocument().setAttrNode(argn, previous);
        if (!argn.isNormalized()) {
            this.ownerNode.isNormalized(false);
        }
        return previous;
    }

    public Node removeNamedItem(String name) throws DOMException {
        return this.internalRemoveNamedItem(name, true);
    }

    Node safeRemoveNamedItem(String name) {
        return this.internalRemoveNamedItem(name, false);
    }

    protected Node removeItem(Node item, boolean addDefault) throws DOMException {
        int index = -1;
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (this.nodes.elementAt(i) != item) continue;
                index = i;
                break;
            }
        }
        if (index < 0) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        return this.remove((AttrImpl)item, index, addDefault);
    }

    protected final Node internalRemoveNamedItem(String name, boolean raiseEx) {
        if (this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            if (raiseEx) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
            return null;
        }
        return this.remove((AttrImpl)this.nodes.elementAt(i), i, true);
    }

    private final Node remove(AttrImpl attr, int index, boolean addDefault) {
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        String name = attr.getNodeName();
        if (attr.isIdAttribute()) {
            ownerDocument.removeIdentifier(attr.getValue());
        }
        if (this.hasDefaults() && addDefault) {
            Node d;
            NamedNodeMapImpl defaults = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (defaults != null && (d = defaults.getNamedItem(name)) != null && this.findNamePoint(name, index + 1) < 0) {
                NodeImpl clone = (NodeImpl)d.cloneNode(true);
                if (d.getLocalName() != null) {
                    ((AttrNSImpl)clone).namespaceURI = attr.getNamespaceURI();
                }
                clone.ownerNode = this.ownerNode;
                clone.isOwned(true);
                clone.isSpecified(false);
                this.nodes.setElementAt(clone, index);
                if (attr.isIdAttribute()) {
                    ownerDocument.putIdentifier(clone.getNodeValue(), (ElementImpl)this.ownerNode);
                }
            } else {
                this.nodes.removeElementAt(index);
            }
        } else {
            this.nodes.removeElementAt(index);
        }
        attr.ownerNode = ownerDocument;
        attr.isOwned(false);
        attr.isSpecified(true);
        attr.isIdAttribute(false);
        ownerDocument.removedAttrNode(attr, this.ownerNode, name);
        return attr;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        return this.internalRemoveNamedItemNS(namespaceURI, name, true);
    }

    Node safeRemoveNamedItemNS(String namespaceURI, String name) {
        return this.internalRemoveNamedItemNS(namespaceURI, name, false);
    }

    protected final Node internalRemoveNamedItemNS(String namespaceURI, String name, boolean raiseEx) {
        CoreDocumentImpl ownerDocument = this.ownerNode.ownerDocument();
        if (ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            if (raiseEx) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
            return null;
        }
        AttrImpl n = (AttrImpl)this.nodes.elementAt(i);
        if (n.isIdAttribute()) {
            ownerDocument.removeIdentifier(n.getValue());
        }
        String nodeName = n.getNodeName();
        if (this.hasDefaults()) {
            Node d;
            NamedNodeMapImpl defaults = ((ElementImpl)this.ownerNode).getDefaultAttributes();
            if (defaults != null && (d = defaults.getNamedItem(nodeName)) != null) {
                int j = this.findNamePoint(nodeName, 0);
                if (j >= 0 && this.findNamePoint(nodeName, j + 1) < 0) {
                    NodeImpl clone = (NodeImpl)d.cloneNode(true);
                    clone.ownerNode = this.ownerNode;
                    if (d.getLocalName() != null) {
                        ((AttrNSImpl)clone).namespaceURI = namespaceURI;
                    }
                    clone.isOwned(true);
                    clone.isSpecified(false);
                    this.nodes.setElementAt(clone, i);
                    if (clone.isIdAttribute()) {
                        ownerDocument.putIdentifier(clone.getNodeValue(), (ElementImpl)this.ownerNode);
                    }
                } else {
                    this.nodes.removeElementAt(i);
                }
            } else {
                this.nodes.removeElementAt(i);
            }
        } else {
            this.nodes.removeElementAt(i);
        }
        n.ownerNode = ownerDocument;
        n.isOwned(false);
        n.isSpecified(true);
        n.isIdAttribute(false);
        ownerDocument.removedAttrNode(n, this.ownerNode, name);
        return n;
    }

    public NamedNodeMapImpl cloneMap(NodeImpl ownerNode) {
        AttributeMap newmap = new AttributeMap((ElementImpl)ownerNode, null);
        newmap.hasDefaults(this.hasDefaults());
        newmap.cloneContent(this);
        return newmap;
    }

    protected void cloneContent(NamedNodeMapImpl srcmap) {
        int size;
        Vector srcnodes = srcmap.nodes;
        if (srcnodes != null && (size = srcnodes.size()) != 0) {
            if (this.nodes == null) {
                this.nodes = new Vector(size);
            }
            this.nodes.setSize(size);
            for (int i = 0; i < size; ++i) {
                NodeImpl n = (NodeImpl)srcnodes.elementAt(i);
                NodeImpl clone = (NodeImpl)n.cloneNode(true);
                clone.isSpecified(n.isSpecified());
                this.nodes.setElementAt(clone, i);
                clone.ownerNode = this.ownerNode;
                clone.isOwned(true);
            }
        }
    }

    void moveSpecifiedAttributes(AttributeMap srcmap) {
        int nsize = srcmap.nodes != null ? srcmap.nodes.size() : 0;
        for (int i = nsize - 1; i >= 0; --i) {
            AttrImpl attr = (AttrImpl)srcmap.nodes.elementAt(i);
            if (!attr.isSpecified()) continue;
            srcmap.remove(attr, i, false);
            if (attr.getLocalName() != null) {
                this.setNamedItem(attr);
                continue;
            }
            this.setNamedItemNS(attr);
        }
    }

    protected void reconcileDefaults(NamedNodeMapImpl defaults) {
        int nsize = this.nodes != null ? this.nodes.size() : 0;
        for (int i = nsize - 1; i >= 0; --i) {
            AttrImpl attr = (AttrImpl)this.nodes.elementAt(i);
            if (attr.isSpecified()) continue;
            this.remove(attr, i, false);
        }
        if (defaults == null) {
            return;
        }
        if (this.nodes == null || this.nodes.size() == 0) {
            this.cloneContent(defaults);
        } else {
            int dsize = defaults.nodes.size();
            for (int n = 0; n < dsize; ++n) {
                AttrImpl d = (AttrImpl)defaults.nodes.elementAt(n);
                int i = this.findNamePoint(d.getNodeName(), 0);
                if (i >= 0) continue;
                i = -1 - i;
                NodeImpl clone = (NodeImpl)d.cloneNode(true);
                clone.ownerNode = this.ownerNode;
                clone.isOwned(true);
                clone.isSpecified(false);
                this.nodes.insertElementAt(clone, i);
            }
        }
    }
}

