/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.ctx;

import com.sun.jndi.toolkit.ctx.PartialCompositeContext;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;

public class Continuation
extends ResolveResult {
    protected Name starter;
    protected Object followingLink = null;
    protected Hashtable environment = null;
    protected boolean continuing = false;
    protected Context resolvedContext = null;
    protected Name relativeResolvedName = null;
    private static final long serialVersionUID = 8162530656132624308L;

    public Continuation() {
    }

    public Continuation(Name top, Hashtable environment) {
        this.starter = top;
        this.environment = environment;
    }

    public boolean isContinue() {
        return this.continuing;
    }

    public void setSuccess() {
        this.continuing = false;
    }

    public NamingException fillInException(NamingException e) {
        e.setRemainingName(this.remainingName);
        e.setResolvedObj(this.resolvedObj);
        if (this.starter == null) {
            e.setResolvedName(null);
        } else if (this.remainingName == null) {
            e.setResolvedName(this.starter);
        } else {
            e.setResolvedName(this.starter.getPrefix(this.starter.size() - this.remainingName.size()));
        }
        if (e instanceof CannotProceedException) {
            CannotProceedException cpe = (CannotProceedException)e;
            Hashtable env = this.environment == null ? new Hashtable(11) : (Hashtable)this.environment.clone();
            cpe.setEnvironment(env);
            cpe.setAltNameCtx(this.resolvedContext);
            cpe.setAltName(this.relativeResolvedName);
        }
        return e;
    }

    public void setErrorNNS(Object resObj, Name remain) {
        Name nm = (Name)remain.clone();
        try {
            nm.add("");
        }
        catch (InvalidNameException e) {
            // empty catch block
        }
        this.setErrorAux(resObj, nm);
    }

    public void setErrorNNS(Object resObj, String remain) {
        CompositeName rname = new CompositeName();
        try {
            if (remain != null && !remain.equals("")) {
                rname.add(remain);
            }
            rname.add("");
        }
        catch (InvalidNameException e) {
            // empty catch block
        }
        this.setErrorAux(resObj, rname);
    }

    public void setError(Object resObj, Name remain) {
        this.remainingName = remain != null ? (Name)remain.clone() : null;
        this.setErrorAux(resObj, this.remainingName);
    }

    public void setError(Object resObj, String remain) {
        CompositeName rname = new CompositeName();
        if (remain != null && !remain.equals("")) {
            try {
                rname.add(remain);
            }
            catch (InvalidNameException e) {
                // empty catch block
            }
        }
        this.setErrorAux(resObj, rname);
    }

    private void setErrorAux(Object resObj, Name rname) {
        this.remainingName = rname;
        this.resolvedObj = resObj;
        this.continuing = false;
    }

    private void setContinueAux(Object resObj, Name relResName, Context currCtx, Name remain) {
        if (resObj instanceof LinkRef) {
            this.setContinueLink(resObj, relResName, currCtx, remain);
        } else {
            this.remainingName = remain;
            this.resolvedObj = resObj;
            this.relativeResolvedName = relResName;
            this.resolvedContext = currCtx;
            this.continuing = true;
        }
    }

    public void setContinueNNS(Object resObj, Name relResName, Context currCtx) {
        CompositeName rname = new CompositeName();
        this.setContinue(resObj, relResName, currCtx, PartialCompositeContext._NNS_NAME);
    }

    public void setContinueNNS(Object resObj, String relResName, Context currCtx) {
        CompositeName relname = new CompositeName();
        try {
            relname.add(relResName);
        }
        catch (NamingException e) {
            // empty catch block
        }
        this.setContinue(resObj, relname, currCtx, PartialCompositeContext._NNS_NAME);
    }

    public void setContinue(Object obj, Name relResName, Context currCtx) {
        this.setContinueAux(obj, relResName, currCtx, (Name)PartialCompositeContext._EMPTY_NAME.clone());
    }

    public void setContinue(Object obj, Name relResName, Context currCtx, Name remain) {
        this.remainingName = remain != null ? (Name)remain.clone() : new CompositeName();
        this.setContinueAux(obj, relResName, currCtx, this.remainingName);
    }

    public void setContinue(Object obj, String relResName, Context currCtx, String remain) {
        CompositeName relname = new CompositeName();
        if (!relResName.equals("")) {
            try {
                relname.add(relResName);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        CompositeName rname = new CompositeName();
        if (!remain.equals("")) {
            try {
                rname.add(remain);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        this.setContinueAux(obj, relname, currCtx, rname);
    }

    @Deprecated
    public void setContinue(Object obj, Object currCtx) {
        this.setContinue(obj, null, (Context)currCtx);
    }

    private void setContinueLink(Object linkRef, Name relResName, Context resolvedCtx, Name rname) {
        this.followingLink = linkRef;
        this.remainingName = rname;
        this.resolvedObj = resolvedCtx;
        this.relativeResolvedName = PartialCompositeContext._EMPTY_NAME;
        this.resolvedContext = resolvedCtx;
        this.continuing = true;
    }

    public String toString() {
        if (this.remainingName != null) {
            return this.starter.toString() + "; remainingName: '" + this.remainingName + "'";
        }
        return this.starter.toString();
    }

    public String toString(boolean detail) {
        if (!detail || this.resolvedObj == null) {
            return this.toString();
        }
        return this.toString() + "; resolvedObj: " + this.resolvedObj + "; relativeResolvedName: " + this.relativeResolvedName + "; resolvedContext: " + this.resolvedContext;
    }
}

