// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_WIZARD_DIALOG_H
#define _HILDONMM_WIZARD_DIALOG_H


#include <glibmm.h>

/*
 * Copyright (c) 2005-2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/dialog.h>
#include <gtkmm/notebook.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonWizardDialog HildonWizardDialog;
typedef struct _HildonWizardDialogClass HildonWizardDialogClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class WizardDialog_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum WizardDialogResponse
{
  WIZARD_DIALOG_PREVIOUS,
  WIZARD_DIALOG_NEXT,
  WIZARD_DIALOG_FINISH
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::WizardDialogResponse> : public Glib::Value_Enum<Hildon::WizardDialogResponse>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** The WizardDialog dialog provides a guided configuration
 * process. The dialog has four standard buttons, previous, next,
 * finish, cancel, and contains several pages with optional icons.
 * Response buttons are dimmed/undimmed automatically and the standard
 * icon is shown/hidden in response to page navigation. The notebook
 * widget provided by users contains the actual wizard pages.
 *
 * See WizardDialogResponse for the possible responses from
 * Gtk::Dialog::run() and Gtk::Dialog::signal_reponse().
 *
 * @ingroup HildonDialogs
 */

class WizardDialog : public Gtk::Dialog
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef WizardDialog CppObjectType;
  typedef WizardDialog_Class CppClassType;
  typedef HildonWizardDialog BaseObjectType;
  typedef HildonWizardDialogClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~WizardDialog();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class WizardDialog_Class;
  static CppClassType wizarddialog_class_;

  // noncopyable
  WizardDialog(const WizardDialog&);
  WizardDialog& operator=(const WizardDialog&);

protected:
  explicit WizardDialog(const Glib::ConstructParams& construct_params);
  explicit WizardDialog(HildonWizardDialog* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonWizardDialog*       gobj()       { return reinterpret_cast<HildonWizardDialog*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonWizardDialog* gobj() const { return reinterpret_cast<HildonWizardDialog*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:

  
public:
  /** Creates a new Hildon::WizardDialog.
   *
   * @param wizard_name The name of dialog.
   * @param wizard_notebook The notebook to be shown on the dialog.
   */
  WizardDialog(const Glib::ustring& wizard_name, Gtk::Notebook& wizard_notebook);

 /** Creates a new Hildon::WizardDialog.
   *
   * Remember to call set_wizard_notebook().
   *
   * @param wizard_name The name of dialog.
   */
  explicit WizardDialog(const Glib::ustring& wizard_name);

  /** Creates a new Hildon::WizardDialog.
   *
   * @param parent a Gtk::Window.
   * @param wizard_name The name of dialog.
   * @param wizard_notebook The notebook to be shown on the dialog.
   */
  WizardDialog(Gtk::Window& parent, const Glib::ustring& wizard_name,
               Gtk::Notebook& wizard_notebook);
  

  /** Sets the Notebook used by the WizardDialog.
   * Each page in the notebook will be a page in the wizard dialog.
   */
  void set_wizard_notebook(Gtk::Notebook& notebook);

  /** Gets the Notebook used by the WizardDialog.
   */
  Gtk::Notebook* get_wizard_notebook();

  /** Gets the Notebook used by the WizardDialog.
   */
  const Gtk::Notebook* get_wizard_notebook() const;

  
  /** Sets the page forwarding function to be @a page_func. This function
   * will be used to determine whether it is possible to go to the next page
   * when the user presses the forward button. Setting @a page_func to <tt>0</tt>
   * wil make the wizard to simply go always to the next page.
   * 
   * @newin{2,2}
   * @param page_func The Hildon::WizardDialogPageFunc.
   * @param data User data for @a page_func.
   * @param destroy Destroy notifier for @a data.
   */

  void set_forward_page_func(const sigc::slot<bool, int>& page_func);
  /* Unset the WizardDialogPageFunc, causing the WizardDialog to always go to
   * the next page on clicking the next button.
   */
  void unset_forward_page_func();

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the HildonWizardDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_wizard_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The name of the HildonWizardDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_wizard_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkNotebook object to be used in the HildonWizardDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Gtk::Notebook*> property_wizard_notebook() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GtkNotebook object to be used in the HildonWizardDialog.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Gtk::Notebook*> property_wizard_notebook() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If the wizard should autotitle itself.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_autotitle() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** If the wizard should autotitle itself.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_autotitle() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::WizardDialog
   */
  Hildon::WizardDialog* wrap(HildonWizardDialog* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_WIZARD_DIALOG_H */

