// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _HILDONMM_BUTTON_H
#define _HILDONMM_BUTTON_H


#include <glibmm.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/button.h>
#include <gtkmm/enums.h>
#include <gtkmm/sizegroup.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _HildonButton HildonButton;
typedef struct _HildonButtonClass HildonButtonClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{ class Button_Class; } // namespace Hildon
namespace Hildon
{

/** @addtogroup hildonmmEnums Enums and Flags */

/**
 * @ingroup hildonmmEnums
 */
enum ButtonArrangement
{
  BUTTON_ARRANGEMENT_HORIZONTAL,
  BUTTON_ARRANGEMENT_VERTICAL
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::ButtonArrangement> : public Glib::Value_Enum<Hildon::ButtonArrangement>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{

/**
 * @ingroup hildonmmEnums
 */
enum ButtonStyle
{
  BUTTON_STYLE_NORMAL,
  BUTTON_STYLE_PICKER
};

} // namespace Hildon


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Hildon::ButtonStyle> : public Glib::Value_Enum<Hildon::ButtonStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Hildon
{


/** @defgroup HildonButtons Buttons
 */

//TODO: Why doesn't this show up in the HildonButtons or HildonWidgets doxgen module page?

/* The Hildon::Button widget is a clickable button, derived from Gtk::Button widget, 
 * providing additional features specific to the Hildon framework.
 *
 * The height of a Hildon::Button can be set to either "finger" height or "thumb" height. 
 * It can also be configured to use halfscreen or fullscreen width. Alternatively, 
 * either dimension can be set to "auto" so it behaves like a standard Gtk::Button.
 *
 * The Hildon::Button can hold any valid child widget, but it usually contains two labels, 
 * named title and value, and it can also contain an image. The contents of the button are 
 * packed together inside a Gtk::Alignment and they do not expand by default (they don't 
 * use the full space of the button).
 *
 * To change the alignment of both labels, use Gtk::Button::set_alignment().
 * To make them expand and use the full space of the button, use Hildon::Button::set_alignment().
 *
 * To change the relative alignment of each label, use set_title_alignment() and set_value_alignment().
 * 
 * If only one label is needed, you may use Gtk::Button instead. //TODO: see also hildon_gtk_button_new(). 
 *
 * @ingroup HildonWidgets
 * @ingroup HildonButtons
 */

class Button : public Gtk::Button
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Button CppObjectType;
  typedef Button_Class CppClassType;
  typedef HildonButton BaseObjectType;
  typedef HildonButtonClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Button();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Button_Class;
  static CppClassType button_class_;

  // noncopyable
  Button(const Button&);
  Button& operator=(const Button&);

protected:
  explicit Button(const Glib::ConstructParams& construct_params);
  explicit Button(HildonButton* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  HildonButton*       gobj()       { return reinterpret_cast<HildonButton*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const HildonButton* gobj() const { return reinterpret_cast<HildonButton*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


private:


public:
  Button();
  
  explicit Button(Gtk::Hildon::SizeType size, ButtonArrangement arrangement = BUTTON_ARRANGEMENT_HORIZONTAL);
  
  //This one is deprecated. We made this change to late to avoid disrupting too much code by removing it.
  explicit Button(Gtk::Hildon::SizeType size, ButtonArrangement arrangement,
                    const Glib::ustring& title, const Glib::ustring& value = Glib::ustring());
             
             
  /** Creates a Button with two labels: title and value.
   * The second label is optional.See also set_title() and set_value().
   *
   * @param title Title of the button (main label).
   * @param value Value of the button (secondary label).
   * @param size Flags to set the size of the button.
   * @param arrangement How the labels should be arranged.
   */
  explicit Button(const Glib::ustring& title, const Glib::ustring& value = Glib::ustring(), Gtk::Hildon::SizeType size = Gtk::Hildon::SIZE_AUTO, ButtonArrangement arrangement = BUTTON_ARRANGEMENT_HORIZONTAL);

  
  /** Sets the main label (title) of the Hildon::Button to @a title.
   * 
   * This will clear any previously set title.
   * 
   * If @a title is set to an empty string, the title label will
   * be hidden and the value label will be realigned.
   * 
   * @newin{2,2}
   * @param title A new main label (title) for the Hildon::Button.
   */
  void set_title(const Glib::ustring& title);

  /** Remove the title from the Button.
   *
   * @see set_title().
   */
  void unset_title();

  
  /** Fetches the text from the main label (title) of the Hildon::Button.
   * 
   * @newin{2,2}
   * @return The text of the title label.
   */
  Glib::ustring get_title() const;

  
  /** Sets the value (subtitle) of the Hildon::Button to @a value.
   * 
   * This will clear any previously set value.
   * 
   * If @a value is set to  an empty string, the value label will
   * be hidden and the title label will be realigned.
   * 
   * @newin{2,2}
   * @param value A new value (subtitle) for the Hildon::Button.
   */
  void set_value(const Glib::ustring& value);

  /** Remove the value (subtitle) from the Button.
   *
   * @see set_value().
   */
  void unset_value();
  
  
  /** Fetches the text from the secondary label (value) of the Hildon::Button.
   * 
   * @newin{2,2}
   * @return The text of the value label.
   */
  Glib::ustring get_value() const;

  
  /** Convenience function to change both labels of a Hildon::Button
   * 
   * @newin{2,2}
   * @param title New text for the button title (main label).
   * @param value New text for the button value (secondary label).
   */
  void set_text(const Glib::ustring& title, const Glib::ustring& value);

  
  /** Sets the image of @a button to the given widget. The previous image
   * (if any) will be removed.
   * 
   * @newin{2,2}
   * @param image A widget to set as the button image.
   */
  void set_image(Gtk::Widget& image);

  /** Remove the image from the Button.
   *
   * @see set_image().
   */
  void unset_image();
  
  
  /** Gets the widget that is currenty set as the image of @a button,
   * previously set with set_image()
   * @return A Gtk::Widget or <tt>0</tt> in case there is no image
   * 
   * @newin{2,2}.
   */
  Gtk::Widget* get_image();
  
  /** Gets the widget that is currenty set as the image of @a button,
   * previously set with set_image()
   * @return A Gtk::Widget or <tt>0</tt> in case there is no image
   * 
   * @newin{2,2}.
   */
  const Gtk::Widget* get_image() const;

  
  /** Sets the position of the image inside @a button. Only Gtk::POS_LEFT
   * and Gtk::POS_RIGHT are currently supported.
   * 
   * @newin{2,2}
   * @param position The position of the image (Gtk::POS_LEFT or Gtk::POS_RIGHT).
   */
  void set_image_position(Gtk::PositionType position);

  
  /** Sets the alignment of the contents of the widget. If you don't need
   * to change @a xscale or @a yscale you can just use
   * gtk_button_set_alignment() instead.
   * 
   * Note that for this method to work properly the, child widget of
   * the Hildon::Button must be a Gtk::Alignment. That is what is used by
   * default, so this function will work unless you add a custom widget
   * to the Hildon::Button.
   * 
   * @newin{2,2}
   * @param xalign The horizontal alignment of the contents, from 0 (left) to 1 (right).
   * @param yalign The vertical alignment of the contents, from 0 (top) to 1 (bottom).
   * @param xscale The amount that the child widget expands horizontally to fill up unused space, from 0 to 1.
   * @param yscale The amount that the child widget expands vertically to fill up unused space, from 0 to 1.
   */
  void set_alignment(float xalign, float yalign, float xscale, float yscale);

  
  /** Sets the alignment of the title label. See also
   * set_alignment() to set the alignment of the whole
   * contents of the button.
   * 
   * @newin{2,2}
   * @param xalign The horizontal alignment of the title label, from 0 (left) to 1 (right).
   * @param yalign The vertical alignment of the title label, from 0 (top) to 1 (bottom).
   */
  void set_title_alignment(float xalign, float yalign);
  
  /** Sets the alignment of the value label. See also
   * set_alignment() to set the alignment of the whole
   * contents of the button.
   * 
   * @newin{2,2}
   * @param xalign The horizontal alignment of the value label, from 0 (left) to 1 (right).
   * @param yalign The vertical alignment of the value label, from 0 (top) to 1 (bottom).
   */
  void set_value_alignment(float xalign, float yalign);
  
  /** Sets the alignment of the image. See also
   * set_alignment() to set the alignment of the whole
   * contents of the button.
   * 
   * @newin{2,2}
   * @param xalign The horizontal alignment of the image, from 0 (left) to 1 (right).
   * @param yalign The vertical alignment of the image, from 0 (top) to 1 (bottom).
   */
  void set_image_alignment(float xalign, float yalign);

  
  /** Adds the title label of @a button to @a size_group.
   * 
   * @newin{2,2}
   * @param size_group A Gtk::SizeGroup for the button title (main label).
   */
  void add_title_size_group(const Glib::RefPtr<Gtk::SizeGroup>& size_group);
  
  /** Adds the value label of @a button to @a size_group.
   * 
   * @newin{2,2}
   * @param size_group A Gtk::SizeGroup for the button value (secondary label).
   */
  void add_value_size_group(const Glib::RefPtr<Gtk::SizeGroup>& size_group);
  
  /** Adds the Hildon::Button image to @a size_group. You must add an image
   * using set_image() before calling this function.
   * 
   * @newin{2,2}
   * @param size_group A Gtk::SizeGroup for the button image.
   */
  void add_image_size_group(const Glib::RefPtr<Gtk::SizeGroup>& size_group);

  
  /** Convenience function to add title, value and image to size
   * groups. A Gtk::SizeGroup of "0" will be ignored.
   * 
   * @newin{2,2}
   * @param title_size_group A Gtk::SizeGroup for the button title (main label), or <tt>0</tt>.
   * @param value_size_group A Gtk::SizeGroup group for the button value (secondary label), or <tt>0</tt>.
   * @param image_size_group A Gtk::SizeGroup group for the button image, or <tt>0</tt>.
   */
  void add_size_groups(const Glib::RefPtr<Gtk::SizeGroup>& title_size_group,
                                    const Glib::RefPtr<Gtk::SizeGroup>& value_size_group,
                                    const Glib::RefPtr<Gtk::SizeGroup>& image_size_group);

  
  /** Sets the style of @a button to @a style. This changes the visual
   * appearance of the button (colors, font sizes) according to the
   * particular style chosen, but the general layout is not altered.
   * 
   * Use Hildon::BUTTON_STYLE_NORMAL to make it look like a normal
   * Hildon::Button, or Hildon::BUTTON_STYLE_PICKER to make it look like
   * a Hildon::PickerButton.
   * 
   * @newin{2,2}
   * @param style A Hildon::ButtonStyle for @a button.
   */
  void set_button_style(ButtonStyle style);
  
  /** Gets the visual style of the button.
   * @return A Hildon::ButtonStyle
   * 
   * @newin{2,2}.
   */
  ButtonStyle get_button_style() const;


};

} // namespace Hildon


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Hildon::Button
   */
  Hildon::Button* wrap(HildonButton* object, bool take_copy = false);
} //namespace Glib


#endif /* _HILDONMM_BUTTON_H */

