from org.maemo.hermes.engine.friend import Friend
from org.maemo.hermes.engine.phonenumber import PhoneNumber
import unittest

class FakeContact():
    def __init__(self, name):
        self.name = name
        self.urls = []
        self.phones = []
        self.photo = None
        self.nickname = None
        self.birthday = None
    def add_url(self, url):
        self.urls.append(url)
        return 1
    def get_urls(self):
        return self.urls
    def get_name(self):
        return self.name
    def get_identifiers(self):
        return [canonical(self.name)]
    def add_phone(self, phone):
        self.phones.append(phone.get_number())
        return 1
    def get_phones(self):
        return self.phones
    def get_photo(self):
        return self.photo
    def set_photo(self, photo):
        self.photo = photo
    def get_nickname(self):
        return self.nickname
    def set_nickname(self, nickname):
        self.nickname = nickname
    def get_birthday(self):
        return self.birthday
    def set_birthday(self, d, m, y):
        self.birthday = '%s-%s-%s' % (y, m, d)

class TestFriend(unittest.TestCase):
    
    def test_that_contacts_are_updated(self):
        friend = Friend(name = 'Bob Smith', source = 'test')
        friend.add_url("http://chitter.com/bob.smith")
        friend.add_url("http://www.friendface.com/bob.smith")
        friend.add_phone(PhoneNumber("01234 567890"))
        
        contact = FakeContact('Person Person')
        friend.update_contact(contact, False)
        assert 'http://chitter.com/bob.smith' in contact.get_urls()
        assert 'http://www.friendface.com/bob.smith' in contact.get_urls()
        
        
    def test_interesting_friends(self):
        friend = Friend(name = 'Bob Smith', source = 'test')
        assert not friend.is_interesting()
        
        friend.add_url('http://chitter.com/bob.smith')
        assert not friend.is_interesting()
        
        friend.add_phone(PhoneNumber("01234 567890"))
        assert friend.is_interesting()

        friend = Friend(name = 'Bob Smith', source = 'test')
        friend.set_birthday_date("01/01/2010")
        assert friend.is_interesting()
        
    
if __name__ == '__main__':
    unittest.main()
