import unittest
import oauth2
import httplib
import simplejson
httplib.HTTPConnection.debuglevel = 1

class IntegrationTestOAuth2(unittest.TestCase):
    access_token = None
    
    # -----------------------------------------------------------------------
    def setUp(self):
        self.oauth = oauth2.OAuth2('5916f12942feea4b3247d42a84371112', '19f7538edd96b6870f2da7e84a6390a4', IntegrationTestOAuth2.access_token)
        
        
    # -----------------------------------------------------------------------
    def test_authorisation(self):
        self.oauth.authorise('https://graph.facebook.com/oauth/authorize',
                             'https://graph.facebook.com/oauth/access_token',
                             {'scope': 'user_about_me,friends_about_me,user_birthday,friends_birthday,user_website,friends_website,user_work_history,friends_work_history'})

        IntegrationTestOAuth2.access_token = self.oauth.get_access_token()
        assert IntegrationTestOAuth2.access_token


    # -----------------------------------------------------------------------
    def test_request(self):
        if not IntegrationTestOAuth2.access_token:
            self.test_authorisation()
            
        response = self.oauth.request('https://graph.facebook.com/me')
        data = simplejson.loads(response)
        if 'error' in data:
            print response
            raise Exception(data['error'])

        print response
        assert 'name' in data and data['name']

    
if __name__ == '__main__':
    unittest.main()
