from friend import Friend

class Service:
    """The notional `Service' for a provider. This is responsible for communicating
       with the backend service and enhancing contacts.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
       
    def __init__(self, service_id):
        """Should make initial calls to the service and retrieve a list of friends."""
        
        self._service_id = service_id


    # -----------------------------------------------------------------------
    def get_id(self):
        """Return the service ID, as given to the service at creation."""
        
        return self._service_id

    
    # -----------------------------------------------------------------------
    def pre_process_contact(self, contact):
        """If the contact have an URL (or similar) that proves an existing matching
           to a friend on this service, then this should be remembered to avoid
           name collision/mapping the same friend to other contacts with the same 
           name."""
         
        return None

    
    def process_friends(self):
        """Called once to signal that it's time to get all friends' data."""
        
        pass
    
    
    # -----------------------------------------------------------------------
    def process_contact(self, contact):
        """Called for each contact in the address book. If the contact can be 
           matched to a Friend, than return the Friend object or None."""
           
        pass
    
    
    # -----------------------------------------------------------------------
    def get_friends_to_create_contacts_for(self):
        """Returns a list of friends to create contacts for, if user has 
           configured the service to report any."""
        
        return []
    
        
    # -----------------------------------------------------------------------
    def get_unmatched_friends(self):
        """Return a list of friends not matched to a contact, or 'None' if manual mapping
           is not supported."""
         
        return None


    # -----------------------------------------------------------------------
    def finalise(self, updated, overwrite=False):
        """Once all contacts have been processed, allows for any tidy-up/additional
           enrichment. If any contacts are updated at this stage, 'updated' should
           be added to."""
           
        pass


# ---------------------------------------------------------------------------
class CredentialsExpiredException(Exception):
    """Used to indicate that the credentials provided, say via OAuth,
       have expired or are incorrect.
       
       Copyright (c) Andrew Flegg <andrew@bleb.org> 2010.
       Released under the Artistic Licence."""
    
    
    pass