#include "main.h"

language languages[52] = {
	{ "auto", "Detect language", FALSE },
	{ "af", "Afrikaans", FALSE },
	{ "sq", "Albanian", FALSE },
	{ "ar", "Arabic", FALSE },
	{ "be", "Belarusian", FALSE },
	{ "bg", "Bulgarian", FALSE },
	{ "ca", "Catalan", FALSE },
	{ "zh-CN", "Chinese", FALSE },
	{ "hr", "Croatian", FALSE },
	{ "cs", "Czech", FALSE },
	{ "da", "Danish", FALSE },
	{ "nl", "Dutch", FALSE },
	{ "en", "English", FALSE },
	{ "et", "Estonia", FALSE },
	{ "tl", "Filipino", FALSE },
	{ "fi", "Finnish", FALSE },
	{ "fr", "French", FALSE },
	{ "gl", "Galician", FALSE },
	{ "de", "German", FALSE },
	{ "el", "Greek", FALSE },
	{ "iw", "Hebrew", FALSE },
	{ "hi", "Hindi", FALSE },
	{ "hu", "Hungarian", FALSE },
	{ "is", "Icelandic", FALSE },
	{ "id", "Indonesian", FALSE },
	{ "ga", "Irish", FALSE },
	{ "it", "Italian", FALSE },
	{ "ja", "Japanese", FALSE },
	{ "ko", "Korean", FALSE },
	{ "lv", "Latvian", FALSE },
	{ "lt", "Lithuanian", FALSE },
	{ "mk", "Macedonian", FALSE },
	{ "ms", "Malay", FALSE },
	{ "mt", "Maltese", FALSE },
	{ "no", "Norwegian", FALSE },
	{ "fa", "Persian", FALSE },
	{ "pl", "Polish", FALSE },
	{ "pt", "Portuguese", FALSE },
	{ "ro", "Romanian", FALSE },
	{ "ru", "Russian", FALSE },
	{ "sr", "Serbian", FALSE },
	{ "sk", "Slovak", FALSE },
	{ "sl", "Slovenian", FALSE },
	{ "es", "Spanish", FALSE },
	{ "sw", "Swahili", FALSE },
	{ "sv", "Swedish", FALSE },
	{ "th", "Thai", FALSE },
	{ "tr", "Turkish", FALSE },
	{ "uk", "Ukrainian", FALSE },
	{ "vi", "Vietnamese", FALSE },
	{ "cy", "Welsh", FALSE },
	{ "yi", "Yiddish", FALSE }
};

int main(int argc, char **argv)
{
	g_thread_init(NULL);
	
	hildon_gtk_init(&argc, &argv);
	g_set_application_name("gTranslate");
	
	settings_init();
	
	clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_can_store(clipboard, NULL, 0);
	
	int i;
	for (i = 0; i < 52; i++)
	{
		gchar* filename = g_strdup_printf(DATAPREFIX"/%s.png", languages[i].str_short);
		GError *error = NULL;
		
		flags[i] = gdk_pixbuf_new_from_file(filename, &error);
		
		if (error)
		{
			g_critical("Could not load pixbuf: %s\n", error->message);
			g_error_free(error);
		}
		
		g_free(filename);
	}
	
	create_window();
	
	gtk_main();
	
	settings_free();

	return 0;
}
