/*
 * Copyright (C) 2008 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of GPXView.
 *
 * GPXView is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GPXView is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GPXView.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MISC_H
#define MISC_H

#define SIZE_NORMAL  0
#define SIZE_BIG     1  /* effect only on non-maemo */
#define SIZE_SMALL   2  /* effect only on maemo */

#define STRIKETHROUGH_NONE  0
#define STRIKETHROUGH       1
#define STRIKETHROUGH_RED   2

#ifdef USE_MAEMO
#define GTK_LABEL_BIG(a)  gtk_label_new(a)
#define GTK_LABEL_SMALL(a) gtk_label_small(a)
GtkWidget *gtk_label_small(char *str);
#else
#define GTK_LABEL_SMALL(a) gtk_label_new(a)
#define GTK_LABEL_BIG(a) gtk_label_big(a)
GtkWidget *gtk_label_big(char *str);
#endif

gboolean pos_valid(pos_t *pos);

GtkWidget *gtk_label_attrib(char *str, int size, int strikethrough);
GtkWidget *gtk_button_attrib(char *str, int size, int strikethrough);
void gtk_label_attrib_set(GtkWidget *label, 
			  char *str, int size, int strikethrough);

void pos_lat_str(char *str, int len, float latitude); 
void pos_lon_str(char *str, int len, float longitude);
GtkWidget *pos_lat(float latitude, int size, int strikethrough);
GtkWidget *pos_lon(float longitude, int size, int strikethrough);
float pos_parse_lat(char *str);
float pos_parse_lon(char *str);
const char *pos_get_bearing_str(pos_t from, pos_t to);

void textbox_enable(GtkWidget *widget);
void textbox_disable(GtkWidget *widget);

int checkdir(char *dir);
char strlastchr(char *str);

pos_t *get_pos(appdata_t *appdata);

GtkWidget *lat_entry_new(float lat);
GtkWidget *lon_entry_new(float lon);
float lat_entry_get(GtkWidget *widget);
float lon_entry_get(GtkWidget *widget);
void lat_entry_set(GtkWidget *widget, float lat);
void lon_entry_set(GtkWidget *widget, float lon);

void lat_label_set(GtkWidget *widget, float lat);
void lon_label_set(GtkWidget *widget, float lon);
void lat_label_attrib_set(GtkWidget *widget, float lat,
			  int size, int strikethrough);
void lon_label_attrib_set(GtkWidget *widget, float lon,
			  int size, int strikethrough);

void distance_str(char *str, int len, float dist, gboolean mil);
float distance_parse(char *str, gboolean imperial);
GtkWidget *dist_entry_new(float dist, gboolean mil);
float dist_entry_get(GtkWidget *widget, gboolean mil);
void dist_entry_set(GtkWidget *widget, float dist, gboolean mil);

void angle_str(char *str, int len, float angle); 
float angle_parse(char *str);
GtkWidget *angle_entry_new(float angle);
float angle_entry_get(GtkWidget *widget);
void angle_entry_set(GtkWidget *widget, float angle);

GtkWidget *left_label_new(char *str);

#ifndef USE_MAEMO
#ifdef ENABLE_BROWSER_INTERFACE
extern int browser_url(appdata_t *appdata, char *url);
#endif
#endif

void rmdir_recursive(char *path);
GtkWidget *link_button_attrib(appdata_t *appdata, char *str, char *url, 
		       int size, int strikethrough);
GtkWidget *link_button_by_id(appdata_t *appdata, char *str, 
			     const char *type, int id);
GtkWidget *link_icon_button_by_id(appdata_t *appdata, GtkWidget *icon, 
			     const char *type, int id);
GtkWidget *simple_text_widget(char *text);

/* convenience-addons for the lat/lon entries */
GtkWidget *preset_coordinate_picker(appdata_t *appdata, GtkWidget *lat_entry, GtkWidget *lon_entry);
GtkWidget *goto_coordinate(appdata_t *appdata, GtkWidget *lat_entry, GtkWidget *lon_entry);

GtkWidget *entry_new(void);

gboolean pos_differ(pos_t *pos1, pos_t *pos2);
gboolean pos_valid(pos_t *pos);

void misc_init(void);

GtkWidget *toggle_button_new_with_label(char *label);
void toggle_button_set_active(GtkWidget *button, gboolean active);
gboolean toggle_button_get_active(GtkWidget *button);

GtkWidget *check_button_new_with_label(char *label);
void check_button_set_active(GtkWidget *button, gboolean active);
gboolean check_button_get_active(GtkWidget *button);

GtkWidget *button_new(void);
GtkWidget *button_new_with_label(char *label);

GtkWidget *export_file(char *sel_title, char **filename);

GtkWidget *number_editor_new(int current, int min, int max);
int number_editor_get_value(GtkWidget *widget);

#endif // MISC_H
