#!/bin/bash
FORMAT=.png
STAR=star.png
STAR_LIGHT=star_light.png
STAR_HALF=star_half.png
PWID=`identify $STAR | cut -d' ' -f3 - | cut -dx -f1 -` 
HWID=$(($PWID/2))
SIZE=${PWID}x${PWID}
convert $STAR -crop ${HWID}x${PWID}+0+0 +repage star_left.png
convert $STAR_LIGHT -crop ${HWID}x${PWID}+${HWID}+0 +repage star_right.png
montage -background \#00000000 -geometry ${HWID}x${PWID} -adjoin star_left.png star_right.png $STAR_HALF 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT stars0$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT stars1$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR_HALF $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT stars1_5$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR_LIGHT $STAR_LIGHT $STAR_LIGHT stars2$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR_HALF $STAR_LIGHT $STAR_LIGHT stars2_5$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR $STAR_LIGHT $STAR_LIGHT stars3$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR $STAR_HALF $STAR_LIGHT stars3_5$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR $STAR $STAR_LIGHT stars4$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR $STAR $STAR_HALF stars4_5$FORMAT 
montage -background \#00000000 -tile 5x1 -geometry $SIZE $STAR $STAR $STAR $STAR $STAR stars5$FORMAT 
rm star_left.png star_right.png $STAR_HALF
