#include "latitude.h"

LatitudeGUI::LatitudeGUI(QMainWindow *parent) : QMainWindow(parent) {
    setting = new QSettings();
    gps = new GpsMaemo5(this);
    glatitude = new GoogleLatitude(this);

    connect(gps, SIGNAL(fix()), this, SLOT(set()));
    connect(glatitude, SIGNAL(glat_ok()), this, SLOT(latitude_ok()));
    connect(glatitude, SIGNAL(glat_error()), this, SLOT(latitude_error()));

    set_config();
    if ( 0 ) gps->config(15, 3, 0);

    gps->refresh();

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    setWindowTitle(tr("Latitude & Buzz"));

    maps = new QWebView();
    connect(maps, SIGNAL(loadFinished(bool)), this, SLOT(maps_login()));

    maps->settings()->setAttribute(QWebSettings::PluginsEnabled, true);
    maps->load(QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude"));

    setCentralWidget(maps);

    menuBar()->addAction(tr("&Latitude"), this, SLOT(mode_latitude()));
    menuBar()->addAction(tr("&Buzz"), this, SLOT(mode_buzz()));
    menuBar()->addAction(tr("&Config"), this, SLOT(config()));

    demonio = new QAction(this);
    if ( system("killall -0 GoogleLatitudeDaemon 2> /dev/null" ) ) {
        demonio->setText(tr("&Start Daemon"));
    } else {
        demonio->setText(tr("&Stop Daemon"));
    }
    connect(demonio, SIGNAL(triggered()), this, SLOT(mode_demonio()));
    menuBar()->addAction(demonio);
}

void LatitudeGUI::set() {
    qDebug() << "LatitudeGUI: set";
    glatitude->update(gps->get_lat(),
                      gps->get_lon(),
                      gps->get_acc());
}

void LatitudeGUI::set_config() {
    qDebug() << "LatitudeGUI: set_config";
    glatitude->set_login(setting->value("user","my_username").toString(),
                         setting->value("pass","my_password").toString());

    gps->config(setting->value("interval",1800).toInt(),
                setting->value("wait",30).toInt(),
                setting->value("method","cell").toString());
}

void LatitudeGUI::latitude_ok() {
    qDebug() << "LatitudeGUI: ok";
}

void LatitudeGUI::latitude_error() {
#ifdef Q_WS_MAEMO_5
    QString error_message = tr("<b>Error in Authentification!</b><br><br>") +
                            tr("Plese verify your login details<br>");
    QMaemo5InformationBox::information(this, error_message,
                                       QMaemo5InformationBox::NoTimeout);
#endif
    qDebug() << "LatitudeGUI: no auth";
    config();
}

void LatitudeGUI::maps_login() {
    if ( maps->url() == QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude") ) {
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Email').value = \"%1\";").arg(
                        setting->value("user").toString()));
        maps->page()->mainFrame()->evaluateJavaScript(
                QString("document.getElementById('Passwd').value = \"%1\";").arg(
                        setting->value("pass").toString()));
        maps->page()->mainFrame()->evaluateJavaScript("document.getElementById('gaia_loginform').submit();");
    }
    if ( maps->url() == QUrl::fromEncoded("https://www.google.com/accounts/ServiceLoginAuth") ) {
        latitude_error();
    }
}

void LatitudeGUI::mode_buzz() {
    maps->load(QUrl::fromEncoded("http://www.google.com/maps/m?l-view=map&l-lci=m,com.google.latitudepublicupdates&ac=f,s,l"));
}

void LatitudeGUI::mode_latitude() {
    maps->load(QUrl::fromEncoded("https://www.google.com/accounts/ServiceLogin?service=friendview&continue=http://www.google.com/maps/m?mode=latitude"));
}

void LatitudeGUI::mode_demonio() {
    if ( ! system("killall -0 GoogleLatitudeDaemon 2> /dev/null" ) ) {
        system("killall GoogleLatitudeDaemon 2> /dev/null");
        demonio->setText(tr("&Start Daemon"));
    } else {
        QProcess *cli = new QProcess(this);
        cli->startDetached(QCoreApplication::applicationDirPath()+QDir::separator()+"GoogleLatitudeDaemon");
        qDebug() << "LatitudeGUI: demonio" << QCoreApplication::applicationDirPath()+QDir::separator()+"GoogleLatitudeDaemon";
        if ( ! system("killall -0 GoogleLatitudeDaemon 2> /dev/null" ) ) {
            demonio->setText(tr("&Stop Daemon"));
        }
    }
}

void LatitudeGUI::config() {
    gps->forcestop();

    QDialog *dialoglogin = new QDialog(this);

    QLineEdit *login_user = new QLineEdit(setting->value("user","my_username").toString());
    QLineEdit *login_pass = new QLineEdit(setting->value("pass","my_password").toString());
    login_pass->setEchoMode(QLineEdit::Password);

    QLineEdit *gps_interval = new QLineEdit(setting->value("interval",1800).toString());
    QLineEdit *gps_wait = new QLineEdit(setting->value("wait",30).toString());

    QCheckBox *daemon_use = new QCheckBox();
    if ( setting->value("daemon",false).toBool() ) {
        daemon_use->setCheckState(Qt::Checked);
    } else {
        daemon_use->setCheckState(Qt::Unchecked);
    }

    QRadioButton *gps_cell = new QRadioButton(tr("&Cell Tower"));
    QRadioButton *gps_both = new QRadioButton(tr("&Both"));
    QRadioButton *gps_agps = new QRadioButton(tr("Only &Gps"));

    QString gps_setting = setting->value("method","cell").toString();
    if ( gps_setting == QString("cell") ) {
        gps_cell->setChecked(true);
    } else if ( gps_setting == QString("both") ) {
        gps_both->setChecked(true);
    } else if ( gps_setting == QString("agps") ) {
        gps_agps->setChecked(true);
    } else {
        gps_cell->setChecked(true);
    }

    QFormLayout *layout_form = new QFormLayout();

    layout_form->addRow(tr("&Username"), login_user);
    layout_form->addRow(tr("&Password"), login_pass);
    connect(login_user, SIGNAL(textEdited(QString)), this, SLOT(save_user(QString)));
    connect(login_user, SIGNAL(returnPressed()), login_pass, SLOT(setFocus()));
    connect(login_pass, SIGNAL(textEdited(QString)), this, SLOT(save_pass(QString)));
    connect(login_pass, SIGNAL(returnPressed()), dialoglogin, SLOT(accept()));

    layout_form->addRow(tr("&Interval for Updates"), gps_interval);
    layout_form->addRow(tr("&Wait for a Fix"), gps_wait);
    layout_form->addRow(tr("&Daemon at Boot"), daemon_use);
    connect(gps_interval, SIGNAL(textEdited(QString)), this, SLOT(save_interval(QString)));
    connect(gps_wait, SIGNAL(textEdited(QString)), this, SLOT(save_wait(QString)));
    connect(daemon_use, SIGNAL(stateChanged(int)), this, SLOT(save_daemon(int)));

    QHBoxLayout *layout_gps = new QHBoxLayout;
    layout_gps->addWidget(gps_cell);
    layout_gps->addWidget(gps_both);
    layout_gps->addWidget(gps_agps);
    layout_form->addRow(layout_gps);
    connect(gps_cell, SIGNAL(clicked()), this, SLOT(save_gps_cell()));
    connect(gps_both, SIGNAL(clicked()), this, SLOT(save_gps_both()));
    connect(gps_agps, SIGNAL(clicked()), this, SLOT(save_gps_agps()));

    dialoglogin->setLayout(layout_form);
    dialoglogin->exec();

    if ( setting->value("interval",1800).toInt() < 300 )
        setting->setValue("interval", 300);
    if ( setting->value("interval",1800).toInt() > 3600 )
        setting->setValue("interval", 3600);

    if ( QString("agps") == setting->value("method","cell").toString() ) {
        if ( setting->value("wait",30).toInt() < 15 )
            setting->setValue("wait", 15);
    } else {
        if ( setting->value("wait",30).toInt() < 5 )
            setting->setValue("wait", 5);
    }
    if ( setting->value("wait",30).toInt() > 120 )
        setting->setValue("wait", 120);

    set_config();
    glatitude->reset();
    gps->refresh();

    mode_latitude();
}

