#ifndef GLATITUDE_H
#define GLATITUDE_H

#include <QtCore>
#include <QtNetwork>

class GoogleLatitude : public QObject {
    Q_OBJECT

signals:
    void glat_ok();
    void glat_error();

public:
    GoogleLatitude(QObject *parent = 0);
    void set_login(QString username, QString password);
    void update(double la, double lo, double ac);
    void reset();

private slots:
    void glat_reply(QNetworkReply *r);

private:
    QString user;
    QString pass;
    bool login_error;
    double latitude;
    double longitude;
    double accuracy;

    QNetworkAccessManager *worker;
    QUrl urllogin;
    QUrl urldologin;
    QUrl urlupdate;
};

#endif // GLATITUDE_H
