#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "settings.h"
#include "foursquarecomm.h"
#include "positionsource.h"
#include "searchvenueswindow.h"
#include "leaderboard.h"
#include "recentcheckinswindow.h"
#include "nearbytipsform.h"

QTM_USE_NAMESPACE

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    FoursquareComm * fsc;
    PositionSource * ps;
    LeaderBoard * lb;
    RecentCheckinsWindow * rcw;
    NearbyTipsForm * ntf;

private:
    Ui::MainWindow *ui;
    Settings * s;
    SearchVenuesWindow * svw;

private slots:
    void on_pbTips_clicked();
    void on_pbRecent_clicked();
    void on_pbLeaderboard_clicked();
    void on_pbSearchVenue_clicked();
    void showAbout();
    void showDonate();

};

#endif // MAINWINDOW_H
