#include "checkindetails.h"
#include "settings.h"
#include <QVBoxLayout>
#if defined(Q_WS_MAEMO_5)
    #include <QMaemo5InformationBox>
#endif

CheckinDetails::CheckinDetails(QWidget *parent) :
    QDialog(parent)
{
    s = new Settings();
    fsc = FoursquareComm::instance();
    ps = PositionSource::instance();

    lTitle = new QLabel(tr("Checkin ..."));

    checkFoursquare = new QCheckBox("On the record");
    checkFoursquare->setChecked(true);

    checkTwitter = new QCheckBox("Twitter");
    if(s->getSetting("checkTwitter")=="y")
        checkTwitter->setChecked(true);

    checkFacebook = new QCheckBox("Facebook");
    if(s->getSetting("checkFacebook")=="y")
        checkTwitter->setChecked(true);

    leShout = new QLineEdit("");
    leShout->setPlaceholderText("Shout");


    checkinButton = new QPushButton(tr("&Checkin"));
    checkinButton->setDefault(true);

    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addWidget(lTitle,0,Qt::AlignHCenter);
    mainLayout->addWidget(leShout);
    mainLayout->addWidget(checkFoursquare);
    mainLayout->addWidget(checkTwitter);
    mainLayout->addWidget(checkFacebook);
    mainLayout->addWidget(checkinButton);
    setLayout(mainLayout);

    setWindowTitle(tr("Checkin"));

    connect(checkinButton, SIGNAL(clicked(bool)), this, SLOT(doCheckin(bool)));
    connect(checkFoursquare, SIGNAL(clicked(bool)), this, SLOT(toggleCheckboxes(bool)));
    setAttribute(Qt::WA_Maemo5AutoOrientation);
}

void CheckinDetails::setVenue(f_venue v)
{
    this->v = v;
    lTitle->setText("Checkin at "+v.name);
}

void CheckinDetails::doCheckin(bool)
{
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator);
    checkTwitter->setEnabled(false);
    checkFacebook->setEnabled(false);
    checkFoursquare->setEnabled(false);
    leShout->setEnabled(false);
    checkinButton->setEnabled(false);

    if(checkTwitter->isChecked())
        s->setSetting("checkTwitter","y");
    else
        s->setSetting("checkTwitter","n");

    if(checkFacebook->isChecked())
        s->setSetting("checkFacebook","y");
    else
        s->setSetting("checkFacebook","n");

    QString broadcast = "";
    if(checkFoursquare->isChecked())
    {
        broadcast.append("public");
        if(checkFacebook->isChecked())
            broadcast.append(",facebook");
        if(checkTwitter->isChecked())
            broadcast.append(",twitter");
    }
    else
        broadcast.append("private");
    QList<f_checkinresult> cr = fsc->checkinVenue(this->v.id, leShout->text() , broadcast ,ps->getLL());

    if(cr.count()>0)
        QMaemo5InformationBox::information(this, "<p>Checked in.</p>", QMaemo5InformationBox::DefaultTimeout);
    else
        QMaemo5InformationBox::information(this, "Could not checkin, error occured.", QMaemo5InformationBox::DefaultTimeout);
    this->setAttribute(Qt::WA_Maemo5ShowProgressIndicator,false);
    crd = new CheckinResultDialog();
    crd->setResult(cr);
    crd->show();
    this->close();
}

void CheckinDetails::toggleCheckboxes(bool checked)
{
    checkTwitter->setEnabled(checked);
    checkFacebook->setEnabled(checked);
}

