#include "unzip.h"
#include "ui_unzip.h"
#include "qmaemo5rotator.h"
#include "qsettings.h"
#include "qfileinfo.h"
#include <QAbstractKineticScroller>
#include "texteditautoresizer.h"
#include "loadimage.h"
#include "unzipdlg.h"
#include "extract.h"
#include "error.h"
#include "sys/vfs.h"

Thread *pepe;
int password;

Unzip::Unzip(QWidget *parent, QString file) :
    QDialog(parent),
    ui(new Ui::Unzip)
{
#ifdef Q_WS_MAEMO_5
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);
#endif
    ui->setupUi(this);

    new TextEditAutoResizer(ui->content);
    //ui->scrollArea->setWidget(ui->content);

    zipfile = file;

    QSettings settings("cepiperez", "filemanager");
    QSettings fileicons("cepiperez", "filemanager_icons");
    QString iconSet = settings.value("IconStyle", "Default").toString();
    QString exten = QFileInfo(file).fileName().toLower();
    int ei = exten.lastIndexOf( "." );
    exten.remove ( 0, ei );
    QString extension = fileicons.value( exten, "file_other.png").toString();
    ui->icon->setPixmap(QPixmap("/opt/filebox/icons/" + iconSet + "/mime/" + extension));
    ui->file->setText( QFileInfo(file).fileName() );

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);

    texto="";

    QCoreApplication::processEvents();

    LoadZip();

}

Unzip::~Unzip()
{
    delete ui;
}


void Unzip::LoadZip()
{
    this->show();
    ui->cancel->setVisible(true);
    ui->progressBar->setVisible(true);
    ui->status->setVisible(false);
    ui->pushButton->setVisible(false);
    QCoreApplication::processEvents();

    QFileInfo fileInfo(zipfile);

    QString exten = fileInfo.fileName().toLower();
    int ei = exten.lastIndexOf( "." );
    exten.remove ( 0, ei + 1 );

    if ( exten == "zip" ) compresor = "unzip";
    else if ( exten == "rar" ) compresor = "unrar";
    else compresor = "tar";

    pepe = new Thread(zipfile);
    //pepe->setPriority(QThread::IdlePriority);
    connect ( pepe, SIGNAL(finished()), this, SLOT(pfinished()) );
    pepe->start();


    texto="";

}

QString Unzip::GetFileSize(int size)
{
    QString ss;
    if (size < 1024) {
      ss = QString("%1 b").arg(size);
    } else if (size < 1024*1024) {
      ss = QString("%1").arg( (double)(size) / 1024);
      size = ss.indexOf(QChar('.')); if ( size > -1 ) { ss.remove(size+3, ss.length()-size-3); }
      ss = ss + " Kb";
    } else {
      ss = QString("%1").arg( (double)(size) / 1024 / 1024);
      size = ss.indexOf(QChar('.')); if ( size > -1 ) { ss.remove(size+3, ss.length()-size-3); }
      ss = ss + " Mb";
    }
    return ss;
}


void Unzip::pfinished(int code)
{
    QString line; int linea=0;
    QString texto2;

    e_root=0; e_mydoc=0; e_mmc=0; e_home=0; e_other=0;

    QFile data( "/home/user/MyDocs/.tempfile" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
        int start=0;
        password = 0;

        QTextStream out(&data);
         while ( !out.atEnd() )
         {
             if ( compresor == "unrar")
             {
                 line = out.readLine();
                 if ( line.indexOf("-----------------")!=-1 && start==0 ) { start=1; line = out.readLine(); }
                 else if ( line.indexOf("-----------------")!=-1 && start==1 ) start=2;
                 if ( start == 1 )
                 {
                     texto2 = out.readLine();
                     texto2 = texto2.trimmed();
                     int ei = texto2.indexOf(" ");
                     line = line.trimmed();
                     texto2.remove ( ei, texto2.length()-ei );
                     if ( line.indexOf("*") == 0 ) { line.remove(0,1); password=1; }
                     if ( QString(texto2).toInt() > 0 ) texto += line.trimmed() + "\n";
                     if ( line != "" ) {
                         if ( line.indexOf("/home/user/MyDocs") > 0 ) e_mydoc = e_mydoc + QString(texto2).toInt();
                         else if ( line.indexOf("/home") > 0 ) e_home = e_home + QString(texto2).toInt();
                         else if ( line.indexOf("/media/mmc1") > 0 ) e_mmc= e_mmc + QString(texto2).toInt();
                         else if ( line.indexOf("/and/") > 0 ) e_other = e_other + QString(texto2).toInt();
                         else e_root = e_root + QString(texto2).toInt();;
                     }
                 }
             }
             else if ( compresor == "unzip")
             {
                 line = out.readLine();
                 if ( line.indexOf("Length")==-1 && line.indexOf("Name")==-1 && line.indexOf("Archive:")==-1 && line.trimmed()!="" )
                 {
                     texto2 = line;
                     int ei = line.lastIndexOf("   ");
                     line.remove ( 0, ei+3 );
                     texto2.remove ( ei, texto2.length()-ei );
                     if ( line.trimmed() != "" )
                     {
                         if ( QString(texto2).toInt() > 0 ) texto += line.trimmed() + "\n";
                         if ( line != "" ) {
                             if ( line.indexOf("/home/user/MyDocs") > 0 ) e_mydoc = e_mydoc + QString(texto2).toInt();
                             else if ( line.indexOf("/home") > 0 ) e_home = e_home + QString(texto2).toInt();
                             else if ( line.indexOf("/media/mmc1") > 0 ) e_mmc= e_mmc + QString(texto2).toInt();
                             else if ( line.indexOf("/and/") > 0 ) e_other = e_other + QString(texto2).toInt();
                             else e_root = e_root + QString(texto2).toInt();;
                         }
                     }
                 }
             }
             else
             {
                 line = out.readLine();
                 texto2 = line;
                 int ei = line.lastIndexOf("  ");
                 line.remove ( 0, ei+1 );
                 texto2.remove ( ei, texto2.length()-ei );
                 if ( QString(texto2).toInt() > 0 ) texto += line.trimmed() + "\n";
                 if ( line != "" ) {
                     if ( line.indexOf("/home/user/MyDocs") > 0 ) e_mydoc = e_mydoc + QString(texto2).toInt();
                     else if ( line.indexOf("/home") > 0 ) e_home = e_home + QString(texto2).toInt();
                     else if ( line.indexOf("/media/mmc1") > 0 ) e_mmc= e_mmc + QString(texto2).toInt();
                     else if ( line.indexOf("/and/") > 0 ) e_other = e_other + QString(texto2).toInt();
                     else e_root = e_root + QString(texto2).toInt();;
                 }
             }
             ++linea;
         }
     }
    data.close();

    /*if ( compresor=="unzip" )
    {
        int i = texto.indexOf( "--------" );
        texto.remove ( 0, i + 12);
        i = texto.lastIndexOf( "--------" );
        texto.remove ( i, texto.length() - i );
    }*/

    /*else if ( compresor=="unrar" )
    {
        int i = texto.indexOf( "\n" );
        texto.remove ( 0, i);
        i = texto.lastIndexOf( "--------" );
        texto.remove ( i, texto.length() - i );
    }*/


    ui->content->setText(texto);
    e_total = e_root + e_home + e_mydoc + e_mmc + e_other;
    ui->status->setText( GetFileSize(e_total) );

    ui->cancel->setVisible(false);
    ui->progressBar->setVisible(false);
    ui->status->setVisible(true);
    ui->pushButton->setVisible(true);

    //system("rm /home/user/MyDocs/.tempfile");

    archivos1 = texto.split("\n");


}

void Unzip::on_cancel_clicked()
{
    pepe->terminate();
    this->close();
}

void Unzip::on_pushButton_clicked()
{
    QSettings settings("cepiperez","filemanager");
    settings.remove("ExtractFolder");

    UnzipDlg* zw = new UnzipDlg(this, QFileInfo(zipfile).path(), zipfile);
    zw->exec();

    QString destino = settings.value("ExtractFolder","").toString();
    if ( destino == "" ) return;



    struct statfs stat;
    unsigned long freeSize = 0;

    int erroresp = 0;

    if ( destino == "/" )
    {
        freeSize = 0;
        QByteArray ba = QString("/").toLatin1();
        const char *str1 = ba.data();
        statfs ( str1, &stat );
        freeSize += stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_root ) erroresp=1;

        ba = QString("/home").toLatin1();
        str1 = ba.data();
        statfs ( str1, &stat );
        freeSize += stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_home ) erroresp=1;

        ba = QString("/home/user/MyDocs").toLatin1();
        str1 = ba.data();
        statfs ( str1, &stat );
        freeSize += stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_mydoc ) erroresp=1;

        ba = QString("/media/mmc1").toLatin1();
        str1 = ba.data();
        statfs ( str1, &stat );
        freeSize += stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_mmc ) erroresp=1;

        ba = QString("/and").toLatin1();
        str1 = ba.data();
        statfs ( str1, &stat );
        freeSize += stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_other ) erroresp=1;

    }
    else
    {
        QByteArray ba = destino.toLatin1();
        const char *str1 = ba.data();
        statfs ( str1, &stat );
        freeSize = stat.f_bsize*stat.f_bfree;
        if ( freeSize < e_total ) erroresp=1;
    }

    int errores=0;

    if ( erroresp == 1 )
    {
        Error* ed = new Error( this, tr("Not enough space to proceed.") );
        ed->exec();
        errores=1;
    }
    if ( errores == 1 ) return;


    QString tf;
    if ( destino == "/" ) tf = "/checking";
    else tf = destino + "/checking";
    QFile destFile(tf);
    if (!destFile.open(QIODevice::WriteOnly))
    {
        Error* ed = new Error( this, tr("You don't have permissions to proceed.") );
        ed->exec();
        errores=1;
    }
    if ( errores == 1 ) return;
    QFile::remove(tf);

    Extract* ew = new Extract(this,zipfile,archivos1);
    ew->exec();


}
