#include "compress.h"
#include "ui_compress.h"
#include "qfileinfo.h"
#include "qdir.h"
#include "qsettings.h"
#include <QProcess>
#include "qtextcodec.h"


Compress::Compress(QWidget *parent, QStringList lista, QString filename, QString path) :
    QDialog(parent),
    ui(new Ui::Compress)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);

    ui->setupUi(this);

    QCoreApplication::processEvents();

    QSettings settings("cepiperez","filemanager");
    QString dir = settings.value("CompressFolder","/home/user/MyDocs").toString();
    base = dir;
    basePath = path;
    baseFile = filename;



    if ( lista.count() > 0 )
    {
        final=0;
        arguments.clear();

        QString met = settings.value("CompressMethod",".tar").toString();
        if ( met == ".tar" ) arguments.append("-cvf");
        else if ( met == ".tar.gz" ) arguments.append("-cvzf");
        else if ( met == ".tar.bz2" ) arguments.append("-cvjf");


        QString finaltarget = dir + "/" + baseFile;
        arguments.append(finaltarget);

        for ( int i=0; i < lista.count(); ++i)
        {
            if ( QFileInfo(lista[i]).isDir() )
            {
                if ( base != basePath ) arguments.append( archivos(lista[i]) );
                else arguments.append( archivos(QFileInfo(lista[i]).fileName()) );
                //arguments.append(QFileInfo(lista[i]).fileName()+"/");
            }
            else
            {
                if ( base != basePath ) arguments.append(lista[i]);
                else arguments.append( QFileInfo(lista[i]).fileName() );

            }
            //arguments.append(QFileInfo(lista[i]).fileName());
        }

        QSettings settings("cepiperez","filemanager");
        settings.setValue("arguments", arguments);

        if ( met == ".zip" ) ars=1; else ars=2;
        ui->pbar->setMaximum( arguments.count() - ars );

        ui->pbar->setValue(0);

        ui->pushButton->setText( tr("Cancel") );

        zipProc = new QProcess(this);

        connect(zipProc, SIGNAL( readyReadStandardOutput() ), this, SLOT( progress() ) );
        connect(zipProc, SIGNAL( finished(int) ), this, SLOT( pfinished(int) ) );

        zipProc->setWorkingDirectory(dir);

        if ( met == ".zip" ) compresor = "zip"; else compresor = "tar";

        progreso=0;
        zipProc->start(compresor, arguments);

        ui->label->setText( "Finished." );

    }

}

void Compress::reject()
{
    if ( final==1 )
    {
     emit done(Rejected);
    }
}

void Compress::progress()
{
    final=0;
    QByteArray data = zipProc->readAllStandardOutput();
    QString str = data.constData();

    if ( compresor=="tar")
    {
        int ei = str.lastIndexOf( "\n" );
        str.remove ( ei, 1 );
        ei = str.lastIndexOf( "\n" );
        str.remove ( 0, ei + 1 );
    }
    else
    {
        int ei = str.lastIndexOf( ": " );
        str.remove ( 0, ei + 1 );
        str = str.trimmed();
    }

    //ui->label->setText(str);
    ui->label->setText( tr("Adding %1...").arg(QFileInfo(str).fileName()) );
    progreso = arguments.indexOf(str) -2 ;
    ui->pbar->setValue(progreso);

}

void Compress::pfinished(int code)
{
    final=1;
    ui->pbar->setMaximum(1); ui->pbar->setValue(1);
    ui->label->setText( tr("Operation finished.") );
    ui->pushButton->setText( tr("Close") );
    if ( base == basePath )
    {
        QSettings settings("cepiperez","filemanager");
        settings.setValue("NeedToRefresh","Yes");
    }

}

QStringList Compress::archivos(QString path1)
{
    QDir dir;
    if ( base != basePath ) dir = QDir( path1 );
    else dir = QDir( base + "/" + path1, "*" );
    QStringList entries = dir.entryList();
    entries.sort();
    QStringList::ConstIterator it = entries.begin();
    dir.setFilter( QDir::AllEntries | QDir::Hidden | QDir::NoDotAndDotDot );

    QStringList archivos2;

    QFileInfoList list = dir.entryInfoList();
    //archivos2.append( QFileInfo(base + "/" + path1).fileName()+"/" );
    for (int i = 0; i < list.size(); ++i)
    {
        QFileInfo fileInfo = list.at(i);
        if ( fileInfo.isDir() )
        {
            QString path2 = path1 + "/" + fileInfo.fileName();
            archivos2.append( archivos(path2) );
        }
        else
        {
            archivos2.append(path1+"/"+list.at(i).fileName());
        }
    }
    return archivos2;



}

Compress::~Compress()
{
    delete ui;
}


void Compress::on_pushButton_clicked()
{
    if ( final==0 )
    {
        /*int pro = zipProc->pid();
        if ( pro != 0 )
        {
            QString sended = QString("killall -9 %1").arg(pro);
            QByteArray ba = sended.toLatin1();
            const char *str1 = ba.data();
            system(str1);
        }*/
        zipProc->terminate();
        QFile::remove(base+"/"+baseFile);
        final=1;
        this->close();
    }
    else
    {
        this->close();
    }


}
