/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef REPOSITORY_H
#define REPOSITORY_H

#include <QtCore>
class Package;
class AAptInterface;

class Repository
{
public:
	explicit Repository();
	virtual ~Repository();

	void setName(QString n_) { iName=n_; }
	void setEnabled(bool e_) { iEnabled=e_; }
    void setUrl(QString url_) { iUrl = url_; }
    void setDir(QString dir_) { iDir = dir_; }
    void setComponents(QString cmp_) { iComponents = cmp_; }
    void setDist(QString d_) { iDist = d_; }
    void setUrlDir(QString url_dir);

	QString name() const { return iName; }
	QString url() const { return iUrl; }
	QString dir() const { return iDir; }
	QString dist() const { return iDist; }
	QString components() const { return iComponents; }
	bool enabled() const { return iEnabled; }
    QString toString(bool noDisable=false) const;
	QStringList toListFileNames() const;
	bool setFromString(QString repo);
	void set(QString name, QString url, QString dir_dist, QString components, bool enabled);
	void set(QString name, QString url, QString dir, QString dist, QString components, bool enabled);

private:
	Repository(const Repository& old);
	Repository operator= (const Repository& old);

	QString iName;
	QString iUrl;
	QString iDir;
	QString iDist;
	QString iComponents;
	bool iEnabled;
};

#endif // REPOSITORY_H
