/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef LOGVIEW_H
#define LOGVIEW_H

#include <QDialog>

namespace Ui {
    class LogView;
}

class LogView : public QDialog
{
    Q_OBJECT

public:
	explicit LogView(QByteArray text, QWidget *parent = 0);
	virtual ~LogView();

	int exec();

protected:
    void changeEvent(QEvent *e);

private:
	LogView(const LogView& old);
	LogView operator= (const LogView& old);

    Ui::LogView *ui;

private slots:
	void on_btnCopy_clicked();
	void on_btnClear_clicked();
};

#endif // LOGVIEW_H
