/*
	This file is part of Faster Application Manager.

	Faster Application Manager is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	Faster Application Manager is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with Faster Application Manager.  If not, see <http://www.gnu.org/licenses/>.

	(C) Heikki Holstila 2010
*/

#ifndef SORTSELECTOR_H
#define SORTSELECTOR_H

#include <QDialog>
#include "packageview.h"

namespace Ui {
    class SortSelector;
}

class SortSelector : public QDialog
{
    Q_OBJECT

public:
	explicit SortSelector(PackageView::sortOrder currOrder, QWidget *parent = 0);
    ~SortSelector();
#ifdef Q_WS_MAEMO_5		// workaround for buggy Qt autorotation
	int exec() {
		QRect r = dynamic_cast<QWidget*>(this->parent())->rect();
		if(r.width() < r.height())
			this->setAttribute(Qt::WA_Maemo5PortraitOrientation);
		int e = QDialog::exec();
		this->setAttribute(Qt::WA_Maemo5AutoOrientation);
		return e;
	}
#endif
	PackageView::sortOrder selectedOperation();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::SortSelector *ui;
};

#endif // SORTSELECTOR_H
