#include "config.h"
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

#define ESPEAKTIME_BIN "espeaktime-now.sh"
#define GCONF_KEY "/apps/Maemo/espeaktime"

void cfg_read(GConfClient *client, struct espeaktime_settings *cfg)
{
	cfg->voice = gconf_client_get_string(client, GCONF_KEY "/voice", NULL);
	cfg->effect = gconf_client_get_string(client, GCONF_KEY "/effect", NULL);
	cfg->text = gconf_client_get_string(client, GCONF_KEY "/text", NULL);
	cfg->amplitude = gconf_client_get_int(client, GCONF_KEY "/amplitude", NULL);
	cfg->pitch = gconf_client_get_int(client, GCONF_KEY "/pitch", NULL);
	cfg->speed = gconf_client_get_int(client, GCONF_KEY "/speed", NULL);
	cfg->ignore_silent = !gconf_client_get_bool(client, GCONF_KEY "/obey_silent_profile", NULL);
	if (!cfg->voice)
		cfg->voice = g_strdup("en-us");
	if (!cfg->effect)
		cfg->effect = g_strdup("");
	if (!cfg->text)
		cfg->text = g_strdup("%H:%M");
	if (!cfg->amplitude)
		cfg->amplitude = 100;
	if (!cfg->pitch)
		cfg->pitch = 50;
	if (!cfg->speed)
		cfg->speed = 170;
}

void cfg_write(GConfClient *client, struct espeaktime_settings *cfg)
{
	gconf_client_add_dir(client, GCONF_KEY, GCONF_CLIENT_PRELOAD_NONE, NULL);
	gconf_client_set_string(client, GCONF_KEY "/voice", cfg->voice, NULL);
	gconf_client_set_string(client, GCONF_KEY "/effect", cfg->effect, NULL);
	gconf_client_set_string(client, GCONF_KEY "/text", cfg->text, NULL);
	gconf_client_set_int(client, GCONF_KEY "/amplitude", cfg->amplitude, NULL);
	gconf_client_set_int(client, GCONF_KEY "/pitch", cfg->pitch, NULL);
	gconf_client_set_int(client, GCONF_KEY "/speed", cfg->speed, NULL);
	gconf_client_set_bool(client, GCONF_KEY "/obey_silent_profile", !cfg->ignore_silent, NULL);
}

void cfg_free(struct espeaktime_settings *cfg)
{
	g_free(cfg->voice);
	g_free(cfg->effect);
	g_free(cfg->text);
}

void cfg_speak(struct espeaktime_settings *cfg, gboolean test_mode)
{
	gchar astr[16], pstr[16], sstr[16];
	gchar vstr[64];
	gchar text[4096];
	time_t t;
	struct tm *tm;
	int res;
	pid_t pid;

	time(&t);
	tm = localtime(&t);

	g_snprintf(astr, sizeof(astr), "%d", cfg->amplitude);
	g_snprintf(pstr, sizeof(pstr), "%d", cfg->pitch);
	g_snprintf(sstr, sizeof(sstr), "%d", cfg->speed);
	g_snprintf(vstr, sizeof(vstr), "%s%s%s", cfg->voice,
		(*cfg->effect) ? "+" : "", cfg->effect);
	strftime(text, sizeof(text), cfg->text, tm);

	setenv("EST_TESTMODE", test_mode ? "1" : "0", 1);
	setenv("EST_IGN_SILENT", (cfg->ignore_silent || test_mode)
		? "1" : "0", 1);

	pid = fork();
	if (pid < 0) {
		g_print("fork: %s", g_strerror(errno));
		return;
	}
	if (pid)
		return;
	g_print("execlp: -a '%s' -p '%s' -s '%s' -v '%s' '%s'\n",
		astr, pstr, sstr, vstr, text);
	res = execlp(ESPEAKTIME_BIN, ESPEAKTIME_BIN,
		"-a", astr, "-p", pstr, "-s", sstr, "-v", vstr,
		text, NULL);
	g_print("execlp: %d (%s)\n", res, g_strerror(errno));
	exit(res);
}
