/*
    Copyright 2010 Marcello V. Mansueto <marcello.m@yahoo.com>

    This file is part of dlh.

    dlh is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dlh is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dlh.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtDBus/QtDBus>

#include "about.h"
#include "ui_about.h"

About::About(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::About)
{
    ui->setupUi(this);
    connect(ui->emailLabel, SIGNAL(linkActivated(QString)), this, SLOT(email(QString)));
    connect(ui->donateLabel, SIGNAL(linkActivated(QString)), this, SLOT(donate(QString)));
}

About::~About()
{
    delete ui;
}

void About::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void About::email(const QString & link) {
    /*QDBusInterface browserd("com.nokia.osso_browser",
    "/com/nokia/osso_browser/request",
    "com.nokia.osso_browser");
    browserd.call ("open_new_window", link);*/
    QDBusInterface modest("com.nokia.modest",
                          "/com/nokia/modest",
                          "com.nokia.modest");
                          modest.call ("MailTo", link);
    close();
}

void About::donate(const QString & link){
    QDBusInterface browserd("com.nokia.osso_browser",
                            "/com/nokia/osso_browser/request",
                            "com.nokia.osso_browser");
    browserd.call ("open_new_window", link);
    close();
}
