/*
 *  datetoday home widget for the maemo desktop.
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DATE_TODAY_PLUGIN_H
#define DATE_TODAY_PLUGIN_H

#include <glib-object.h>

#include <libhildondesktop/libhildondesktop.h>


G_BEGIN_DECLS

typedef struct _DateTodayPlugin DateTodayPlugin;
typedef struct _DateTodayPluginClass DateTodayPluginClass;

#define DATE_TODAY_TYPE_PLUGIN (date_today_plugin_get_type())

#define DATE_TODAY_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST((obj), \
								DATE_TODAY_TYPE_PLUGIN, DateTodayPlugin))

#define DATE_TODAY_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
								    DATE_TODAY_TYPE_PLUGIN))

#define DATE_TODAY_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
									  DATE_TODAY_TYPE_PLUGIN, DateTodayPluginClass))

struct _DateTodayPlugin
{
  HDHomePluginItem hitem;
  gchar* iD;
  gchar* today_string;
  guint time_out_handler;
  int current_day;
  GtkWidget* content;
  DBusGConnection *dbus_conn;
  DBusGProxy *dbus_proxy;
  guint launch_view;
  guint size; 
  guint sheet_size;
  guint date_format;
  GdkPixbuf* background_pixbuf;
  
};

struct _DateTodayPluginClass
{
  HDHomePluginItemClass parent_class;

};

GType date_today_plugin_get_type(void);

#endif
