#include "clipboardmonitor.h"
#include "settings.h"
#if QT_VERSION >= 0x050000
#include <QGuiApplication>
#else
#include <QApplication>
#endif
#include <QClipboard>
#include <QDebug>
#ifdef MEEGO_EDITION_HARMATTAN
#include <QTimer>
#endif

ClipboardMonitor* monitorInstance = 0;

ClipboardMonitor::ClipboardMonitor(QObject *parent) :
    QObject(parent)
  #ifdef MEEGO_EDITION_HARMATTAN
  ,m_timer(0)
  #endif
{
    if (!monitorInstance) {
        monitorInstance = this;
    }
#if QT_VERSION >= 0x050000
    this->connect(QGuiApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
#else
    this->connect(QApplication::clipboard(), SIGNAL(dataChanged()), this, SLOT(onClipboardTextChanged()));
#endif
}

ClipboardMonitor* ClipboardMonitor::instance() {
    return monitorInstance;
}

void ClipboardMonitor::onClipboardTextChanged() {
#ifdef MEEGO_EDITION_HARMATTAN
    if ((m_timer) && (m_timer->isActive())) {
        // QClipboard::dataChanged() signal is emitted twice in Harmattan, so ignore the signal if the timer is still active.
        return;
    }
    else {
        if (!m_timer) {
            m_timer = new QTimer(this);
            m_timer->setInterval(3000);
            m_timer->setSingleShot(true);
        }

        m_timer->start();
    }
#endif
#if QT_VERSION >= 0x050000
    if (QGuiApplication::clipboard()->text().contains(QRegExp("((http://(www.|m.|)youtube.com/(v/|.+)(v=|list=|)|http://youtu.be/))|((http(s|)://(www.|)dailymotion.com/(video|playlist)/|http://dai.ly/)\\w{6})|(http://vimeo.com/\\d+)"))) {
        this->setClipboardUrl(QGuiApplication::clipboard()->text());
    }
#else
    if (QApplication::clipboard()->text().contains(QRegExp("((http://(www.|m.|)youtube.com/(v/|.+)(v=|list=|)|http://youtu.be/))|((http(s|)://(www.|)dailymotion.com/(video|playlist)/|http://dai.ly/)\\w{6})|(http://vimeo.com/\\d+)"))) {
        this->setClipboardUrl(QApplication::clipboard()->text());
    }
#endif
}

void ClipboardMonitor::setClipboardUrl(const QString &url) {
    qDebug() << "Clipboard url: " + url;
    m_clipboardUrl = url;
    emit clipboardUrlChanged(url);

    if (Settings::instance()->monitorClipboard()) {
        emit gotClipboardUrl(url);
    }
}
