#ifndef YOUTUBEUSERPLAYLISTLISTTAB_H
#define YOUTUBEUSERPLAYLISTLISTTAB_H

#include "abstracttab.h"
#include "listview.h"
#include "youtubeuserplaylistlistmodel.h"
#include <QLabel>
#include <QMenu>
#include <QAction>
#include <QGridLayout>

class YouTubeUserPlaylistListTab : public AbstractTab
{
    Q_OBJECT
public:
    explicit YouTubeUserPlaylistListTab(Session *session, QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onPlaylistsLoaded();
    void onItemClicked(const QModelIndex &index);
    void showPlaylist(QSharedPointer<PlaylistItem> playlist);
    void showContextMenu(const QPoint &pos);
    void deletePlaylist();
    void showNewPlaylistDialog();

private:
    Session *m_session;
    ListView *m_listView;
    YouTubeUserPlaylistListModel *m_model;
    QMenu *m_contextMenu;
    QAction *m_deleteAction;
    QAction *m_newPlaylistAction;
    QLabel *m_noResultsLabel;
    QGridLayout *m_grid;
};

#endif // YOUTUBEUSERPLAYLISTLISTTAB_H
