#include "youtubechannelwindow.h"
#include <QMenuBar>

YouTubeChannelWindow::YouTubeChannelWindow(Session *session, const QString &userId, QWidget *parent) :
    StackedWindow(session, parent),
    m_userId(userId),
    m_menu(menuBar()->addMenu("")),
    m_actionGroup(new QActionGroup(this)),
    m_profileAction(new QAction("Pro", this)),
    m_uploadsAction(new QAction("Upl", this)),
    m_favouritesAction(new QAction("Fav", this)),
    m_playlistsAction(new QAction("Play", this)),
    m_subscriptionsAction(new QAction("Subs", this)),
    m_tabWidget(new QStackedWidget(this)),
    m_profileTab(new YouTubeProfileTab(m_session, m_userId, m_tabWidget)),
    m_uploadsTab(0),
    m_favouritesTab(0),
    m_playlistsTab(0),
    m_subscriptionsTab(0)
{
    setCentralWidget(m_tabWidget);

    m_profileAction->setCheckable(true);
    m_profileAction->setActionGroup(m_actionGroup);

    m_uploadsAction->setCheckable(true);
    m_uploadsAction->setActionGroup(m_actionGroup);

    m_favouritesAction->setCheckable(true);
    m_favouritesAction->setActionGroup(m_actionGroup);

    m_playlistsAction->setCheckable(true);
    m_playlistsAction->setActionGroup(m_actionGroup);

    m_subscriptionsAction->setCheckable(true);
    m_subscriptionsAction->setActionGroup(m_actionGroup);

    m_menu->addAction(m_profileAction);
    m_menu->addAction(m_uploadsAction);
    m_menu->addAction(m_favouritesAction);
    m_menu->addAction(m_playlistsAction);
    m_menu->addAction(m_subscriptionsAction);

    m_profileAction->setChecked(true);

    m_tabWidget->setFrameStyle(QFrame::NoFrame);
    m_tabWidget->addWidget(m_profileTab);

    connect(m_profileAction, SIGNAL(triggered()), this, SLOT(showProfile()));
    connect(m_uploadsAction, SIGNAL(triggered()), this, SLOT(showUploads()));
    connect(m_favouritesAction, SIGNAL(triggered()), this, SLOT(showFavourites()));
    connect(m_playlistsAction, SIGNAL(triggered()), this, SLOT(showPlaylists()));
    connect(m_subscriptionsAction, SIGNAL(triggered()), this, SLOT(showSubscriptions()));

    showProfile();
    onOrientationChanged();
}

void YouTubeChannelWindow::clearMenuActions() {
    QList<QAction*> actions = menuBar()->actions();

    for (int i = 1; i < actions.size(); i++) {
        menuBar()->removeAction(actions.at(i));
    }
}

void YouTubeChannelWindow::showProfile() {
    m_tabWidget->setCurrentWidget(m_profileTab);
    setWindowTitle(tr("Profile"));
    clearMenuActions();
}

void YouTubeChannelWindow::showUploads() {
    if (!m_uploadsTab) {
        m_uploadsTab = new YouTubeVideoListTab(m_session, this);
        m_uploadsTab->setVideoFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/uploads?v=2.1&max-results=30").arg(m_userId));
        m_tabWidget->addWidget(m_uploadsTab);
    }

    m_tabWidget->setCurrentWidget(m_uploadsTab);
    setWindowTitle(tr("Uploads"));
    clearMenuActions();
    menuBar()->addActions(m_uploadsTab->actions());
}

void YouTubeChannelWindow::showFavourites() {
    if (!m_favouritesTab) {
        m_favouritesTab = new YouTubeVideoListTab(m_session, this);
        m_favouritesTab->setVideoFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/favorites?v=2.1&max-results=30").arg(m_userId));
        m_tabWidget->addWidget(m_favouritesTab);
    }

    m_tabWidget->setCurrentWidget(m_favouritesTab);
    setWindowTitle(tr("Favourites"));
    clearMenuActions();
    menuBar()->addActions(m_favouritesTab->actions());
}

void YouTubeChannelWindow::showPlaylists() {
    if (!m_playlistsTab) {
        m_playlistsTab = new YouTubePlaylistListTab(m_session, this);
        m_playlistsTab->setPlaylistFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/playlists?v=2.1&max-results=30").arg(m_userId));
        m_tabWidget->addWidget(m_playlistsTab);
    }

    m_tabWidget->setCurrentWidget(m_playlistsTab);
    setWindowTitle(tr("Playlists"));
    clearMenuActions();
}

void YouTubeChannelWindow::showSubscriptions() {
    if (!m_subscriptionsTab) {
        m_subscriptionsTab = new YouTubeUserListTab(m_session, m_userId, this);
        m_subscriptionsTab->setFeed(QString("https://gdata.youtube.com/feeds/api/users/%1/subscriptions?v=2.1&max-results=30").arg(m_userId));
        m_tabWidget->addWidget(m_subscriptionsTab);
    }

    m_tabWidget->setCurrentWidget(m_subscriptionsTab);
    setWindowTitle(tr("Subscriptions"));
    clearMenuActions();
    menuBar()->addActions(m_subscriptionsTab->actions());
}
