#ifndef XTUBEVIDEOLISTMODEL_H
#define XTUBEVIDEOLISTMODEL_H

#include "session.h"
#include "abstractvideolistmodel.h"

class XTubeVideoListModel : public AbstractVideoListModel
{
    Q_OBJECT

public:
    explicit XTubeVideoListModel(Session *session, QObject *parent = 0);
    void search(
            const QString &query = QString(),
            Services::VideoService service = Services::XHamster,
            Queries::QueryOrder order = Queries::Relevance,
            Queries::TimeFilter time = Queries::AllTime,
            Queries::DurationFilter duration = Queries::Any
            );
    inline bool loading() const { return m_loading; }

public slots:
    void getMoreVideos();

private slots:
    void addVideos(QList< QSharedPointer<VideoItem> > videos);
    inline void onError() { setError(true); setLoading(false); }

private:
    inline QString query() const { return m_query; }
    inline void setQuery(const QString &query) { m_query = query; }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; }
    inline Queries::QueryOrder order() const { return m_order; }
    inline void setOrder(Queries::QueryOrder order) { m_order = order; }
    inline Queries::TimeFilter timeFilter() const { return m_time; }
    inline void setTimeFilter(Queries::TimeFilter time) { m_time = time; }
    inline Queries::DurationFilter durationFilter() const { return m_duration; }
    inline void setDurationFilter(Queries::DurationFilter duration) { m_duration = duration; }
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged();

private:
    Session *m_session;
    QString m_query;
    Services::VideoService m_service;
    Queries::QueryOrder m_order;
    Queries::TimeFilter m_time;
    Queries::DurationFilter m_duration;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // XTUBEVIDEOLISTMODEL_H
