#ifndef VIDEOSERVICESELECTOR_H
#define VIDEOSERVICESELECTOR_H

#include "selectionmodels.h"
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>

class VideoServiceSelector : public QMaemo5ValueButton
{
    Q_OBJECT

public:
    explicit VideoServiceSelector(const QString &text, QWidget *parent = 0);
    void setValue(Services::VideoService value);
    Services::VideoService currentValue();
    void showExtras(bool show);
    void showXTube(bool show);

private slots:
    void onSelected();
    
signals:
    void valueChanged(Services::VideoService value);
    
private:
    VideoServiceModel *m_model;
    QMaemo5ListPickSelector *m_selector;
};

#endif // VIDEOSERVICESELECTOR_H
