#ifndef VIDEOITEM_H
#define VIDEOITEM_H

#include "enums.h"
#include "utils.h"
#include <QObject>
#include <QVariantMap>
#include <QUrl>
#include <QStringList>
#include <QtXml/QDomElement>

class VideoItem : public QObject
{
    Q_OBJECT    

public:
    explicit VideoItem(QObject *parent = 0);
    explicit VideoItem(const QVariantMap &video, bool favourite = false, QObject *parent = 0);
    explicit VideoItem(const QDomNode &video, bool favourite = false, QObject *parent = 0);
    ~VideoItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString videoId() const { return m_video_id; }
    inline void setVideoId(const QString &id) { m_video_id = id; }
    inline QUrl url() const { return m_url; }
    inline void setUrl(const QUrl &url) { m_url = url; }
    inline QString title() const { return m_title; }
    inline void setTitle(const QString &title) { m_title = title; emit titleChanged(); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artist_id; }
    inline void setArtistId(const QString &id) { m_artist_id = id; }
    inline QUrl artistAvatarUrl() const { return m_artist_avatar_url; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artist_avatar_url = url; }
    inline QString description() const { return m_description; }
    inline void setDescription(const QString &description) { m_description = description; emit descriptionChanged(); }
    inline int duration() const { return m_duration; }
    inline void setDuration(int duration) { m_duration = duration; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline QStringList tags() const { return m_tags; }
    inline void setTags(const QStringList &tags) { m_tags = tags; emit tagsChanged(); }
    inline int likes() const { return m_likes; }
    inline void setLikes(int likes) { m_likes = likes; emit likesChanged(); }
    inline int dislikes() const { return m_dislikes; }
    inline void setDislikes(int dislikes) { m_dislikes = dislikes; emit dislikesChanged(); }
    inline float rating() const { return m_rating; }
    inline void setRating(float rating) { m_rating = rating; emit ratingChanged(); }
    inline int ratingCount() const { return m_rating_count; }
    inline void setRatingCount(int count) { m_rating_count = count; emit ratingCountChanged(); }
    inline int viewCount() const { return m_view_count; }
    inline void setViewCount(int count) { m_view_count = count; emit viewCountChanged(); }
    inline QUrl thumbnailUrl() const { return m_thumb_url; }
    inline void setThumbnailUrl(const QUrl &url) { m_thumb_url = url; }
    inline QUrl largeThumbnailUrl() const { return m_large_thumb_url; }
    inline void setLargeThumbnailUrl(const QUrl &url) { m_large_thumb_url = url; }
    inline QString filePath() const { return m_filepath; }
    inline void setFilePath(const QString &filePath) { m_filepath = filePath; }
    inline qint64 fileSize() const { return m_filesize; }
    inline void setFileSize(qint64 size) { m_filesize = size; }
    inline qint64 lastModified() const { return m_last_modified; }
    inline void setLastModified(qint64 date) { m_last_modified = date; }
    inline bool liked() const { return m_liked; }
    inline void like() { m_liked = true; setLikes(likes() + 1); emit likedChanged(); }
    inline bool disliked() const { return m_disliked; }
    inline void dislike() { m_disliked = true; setDislikes(dislikes() + 1); emit dislikedChanged(); }
    inline bool favourite() const { return m_favourite; }
    inline void setFavourite(bool isFavourite) { m_favourite = isFavourite; emit favouriteChanged(); }
    inline bool downloaded() const { return m_downloaded; }
    inline void setDownloaded(bool downloaded) { m_downloaded = downloaded; emit downloadedChanged(); }
    inline bool isPrivate() const { return m_private; }
    inline void setPrivate(bool isPrivate) { m_private = isPrivate; emit isPrivateChanged(); }
    inline Services::VideoService service() const { return m_service; }
    inline void setService(Services::VideoService service) { m_service = service; }
    inline QString serviceString() const { return Utils::serviceString(service()); }
    inline bool checked() const { return m_checked; }
    inline void toggleChecked() { m_checked = !m_checked; }
    inline void setChecked(bool checked) { m_checked = checked; }

signals:
    void titleChanged();
    void descriptionChanged();
    void tagsChanged();
    void likesChanged();
    void dislikesChanged();
    void ratingChanged();
    void ratingCountChanged();
    void viewCountChanged();
    void likedChanged();
    void dislikedChanged();
    void favouriteChanged();
    void downloadedChanged();
    void isPrivateChanged();

private:
    QString m_id;
    QString m_video_id;
    QUrl m_url;
    QString m_title;
    QString m_artist;
    QString m_artist_id;
    QUrl m_artist_avatar_url;
    QString m_description;
    int m_duration;
    QString m_date;
    QStringList m_tags;
    int m_likes;
    int m_dislikes;
    int m_rating_count;
    float m_rating;
    int m_view_count;
    QUrl m_thumb_url;
    QUrl m_large_thumb_url;
    QString m_filepath;
    qint64 m_filesize;
    qint64 m_last_modified;
    bool m_liked;
    bool m_disliked;
    bool m_favourite;
    bool m_downloaded;
    bool m_private;
    Services::VideoService m_service;
    bool m_checked;
};

#endif // VIDEOITEM_H
