#include "downloadqualitydialog.h"
#include "separatorlabel.h"

DownloadQualityDialog::DownloadQualityDialog(Settings *settings, QWidget *parent) :
    AbstractDialog(parent),
    m_settings(settings),
    m_youtube1080Checkbox(new QCheckBox("1080P AVC1", this)),
    m_youtube720Checkbox(new QCheckBox("720P AVC1", this)),
    m_youtube480Checkbox(new QCheckBox("480P FLV", this)),
    m_youtube360Checkbox(new QCheckBox("360P FLV", this)),
    m_youtubeNormalCheckbox(new QCheckBox(tr("Normal") + " AVC1", this)),
    m_dailymotion720Checkbox(new QCheckBox("720P AVC1", this)),
    m_dailymotion480Checkbox(new QCheckBox("480P AVC1", this)),
    m_dailymotionNormalCheckbox(new QCheckBox(tr("Normal") + " AVC1", this)),
    m_vimeo720Checkbox(new QCheckBox("720P H264", this)),
    m_vimeo360Checkbox(new QCheckBox("360P H264", this)),
    m_vimeoMobileCheckbox(new QCheckBox(tr("Mobile"), this)),
    m_buttonBox(new QDialogButtonBox(QDialogButtonBox::Cancel | QDialogButtonBox::Save, Qt::Vertical, this)),
    m_scrollArea(new QScrollArea(this)),
    m_grid(new QGridLayout(this))
{
    setWindowTitle(tr("Download quality"));
    setAttribute(Qt::WA_DeleteOnClose, false);

    QWidget *scrollWidget = new QWidget(m_scrollArea);
    QVBoxLayout *vbox = new QVBoxLayout(scrollWidget);

    vbox->addWidget(new SeparatorLabel("YouTube", this));
    vbox->addWidget(m_youtube1080Checkbox);
    vbox->addWidget(m_youtube720Checkbox);
    vbox->addWidget(m_youtube480Checkbox);
    vbox->addWidget(m_youtube360Checkbox);
    vbox->addWidget(m_youtubeNormalCheckbox);
    vbox->addWidget(new SeparatorLabel("Dailymotion", this));
    vbox->addWidget(m_dailymotion720Checkbox);
    vbox->addWidget(m_dailymotion480Checkbox);
    vbox->addWidget(m_dailymotionNormalCheckbox);
    vbox->addWidget(new SeparatorLabel("Vimeo", this));
    vbox->addWidget(m_vimeo720Checkbox);
    vbox->addWidget(m_vimeo360Checkbox);
    vbox->addWidget(m_vimeoMobileCheckbox);

    m_scrollArea->setWidgetResizable(true);
    m_scrollArea->setWidget(scrollWidget);

    connect(m_buttonBox, SIGNAL(accepted()), this, SLOT(saveSettings()));
    connect(m_buttonBox, SIGNAL(rejected()), this, SLOT(reject()));

    loadSettings();
    onOrientationChanged();
}

void DownloadQualityDialog::setLandscapeLayout() {
    setFixedHeight(340);
    m_buttonBox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 0, 1, Qt::AlignBottom);
    }
}

void DownloadQualityDialog::setPortraitLayout() {
    setFixedHeight(600);
    m_buttonBox->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);

    if (m_grid->isEmpty()) {
        m_grid->addWidget(m_scrollArea, 0, 0);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
    else {
        m_grid->removeWidget(m_buttonBox);
        m_grid->addWidget(m_buttonBox, 1, 0, Qt::AlignBottom);
    }
}

void DownloadQualityDialog::loadSettings() {
    m_youtube1080Checkbox->setChecked(m_settings->enableYouTube1080Download());
    m_youtube720Checkbox->setChecked(m_settings->enableYouTube720Download());
    m_youtube480Checkbox->setChecked(m_settings->enableYouTube480Download());
    m_youtube360Checkbox->setChecked(m_settings->enableYouTube360Download());
    m_youtubeNormalCheckbox->setChecked(true);
    m_youtubeNormalCheckbox->setEnabled(false);
    m_dailymotion720Checkbox->setChecked(m_settings->enableDailymotion720Download());
    m_dailymotion480Checkbox->setChecked(m_settings->enableDailymotion480Download());
    m_dailymotionNormalCheckbox->setChecked(true);
    m_dailymotionNormalCheckbox->setEnabled(false);
    m_vimeo720Checkbox->setChecked(m_settings->enableVimeo720Download());
    m_vimeo360Checkbox->setChecked(m_settings->enableVimeo360Download());
    m_vimeoMobileCheckbox->setChecked(true);
    m_vimeoMobileCheckbox->setEnabled(false);
}

void DownloadQualityDialog::saveSettings() {
    m_settings->setEnableYouTube1080Download(m_youtube1080Checkbox->isChecked());
    m_settings->setEnableYouTube720Download(m_youtube720Checkbox->isChecked());
    m_settings->setEnableYouTube480Download(m_youtube480Checkbox->isChecked());
    m_settings->setEnableYouTube360Download(m_youtube360Checkbox->isChecked());
    m_settings->setEnableDailymotion720Download(m_dailymotion720Checkbox->isChecked());
    m_settings->setEnableDailymotion480Download(m_dailymotion480Checkbox->isChecked());
    m_settings->setEnableVimeo720Download(m_vimeo720Checkbox->isChecked());
    m_settings->setEnableVimeo360Download(m_vimeo360Checkbox->isChecked());

    accept();
}
