#include "dailymotionuserplaylistlistmodel.h"

DailymotionUserPlaylistListModel::DailymotionUserPlaylistListModel(Session *session, QObject *parent) :
    QAbstractListModel(parent),
    m_session(session)
{
    if (!m_session->dailymotion()->playlistsLoaded()) {
        m_session->dailymotion()->getPlaylists();
    }

    connect(m_session->dailymotion(), SIGNAL(playlistAddedToCache(int)), this, SLOT(onPlaylistAdded(int)));
    connect(m_session->dailymotion(), SIGNAL(playlistRemovedFromCache(int)), this, SLOT(onPlaylistRemoved(int)));
    connect(m_session->dailymotion(), SIGNAL(playlistUpdated(int)), this, SLOT(onPlaylistUpdated(int)));
}

void DailymotionUserPlaylistListModel::onPlaylistAdded(int row) {
    beginInsertRows(QModelIndex(), row, row);
    endInsertRows();
}

void DailymotionUserPlaylistListModel::onPlaylistRemoved(int row) {
    beginRemoveRows(QModelIndex(), row, row);
    endRemoveRows();
}

void DailymotionUserPlaylistListModel::onPlaylistUpdated(int row) {
    emit dataChanged(index(row), index(row));
}

int DailymotionUserPlaylistListModel::rowCount(const QModelIndex &parent) const {
    Q_UNUSED(parent);

    return m_session->dailymotion()->playlists()->size();
}

QVariant DailymotionUserPlaylistListModel::data(const QModelIndex &index, int role) const {
    switch (role) {
    case IdRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->id();
    case PlaylistIdRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->playlistId();
    case TitleRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->title();
    case ArtistRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->artist();
    case DateRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->date();
    case VideoCountRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->videoCount();
    case DescriptionRole:
        return m_session->dailymotion()->playlists()->at(index.row()).data()->description();
    default:
        return QVariant();
    }
}

