#ifndef COMMENTITEM_H
#define COMMENTITEM_H

#include <QObject>
#include <QUrl>
#include <QtXml/QDomElement>
#include <QVariantMap>

class CommentItem : public QObject
{
    Q_OBJECT    

public:
    explicit CommentItem(QObject *parent = 0): QObject(parent) {}
    explicit CommentItem(const QVariantMap &comment, QObject *parent = 0);
    explicit CommentItem(const QDomNode &comment, QObject *parent = 0);
    ~CommentItem() {}
    inline QString id() const { return m_id; }
    inline void setId(const QString &id) { m_id = id; }
    inline QString body() const { return m_body; }
    inline void setBody(const QString &body) { m_body = body; emit bodyChanged(); }
    inline QString artist() const { return m_artist; }
    inline void setArtist(const QString &artist) { m_artist = artist; }
    inline QString artistId() const { return m_artistId; }
    inline void setArtistId(const QString &id) { m_artistId = id; }
    inline QUrl artistAvatarUrl() const { return m_artistAvatarUrl; }
    inline void setArtistAvatarUrl(const QUrl &url) { m_artistAvatarUrl = url; }
    inline QString date() const { return m_date; }
    inline void setDate(const QString &date) { m_date = date; }
    inline QString videoId() const { return m_videoId; }
    inline void setVideoId(const QString &id) { m_videoId = id; emit videoIdChanged(); }
    inline QString replyId() const { return m_replyId; }
    inline void setReplyId(const QString &id) { m_replyId = id; emit replyIdChanged(); }
    inline int indent() const { return m_indent; }
    inline void setIndent(int indent) { m_indent = indent; }
    inline bool loading() const { return m_loading; }
    inline void setLoading(bool loading) { m_loading = loading; }

signals:
    void bodyChanged();
    void videoIdChanged();
    void replyIdChanged();

private:
    QString m_id;
    QString m_body;
    QString m_artist;
    QString m_artistId;
    QUrl m_artistAvatarUrl;
    QString m_date;
    QString m_videoId;
    QString m_replyId;
    int m_indent;
    bool m_loading;
};

#endif // COMMENTITEM_H
