#ifndef YOUTUBENEWPLAYLISTDIALOG_H
#define YOUTUBENEWPLAYLISTDIALOG_H

#include "abstractdialog.h"
#include <QVariantMap>

class QScrollArea;
class QLineEdit;
class QTextEdit;
class QCheckBox;
class QDialogButtonBox;
class QPushButton;
class QGridLayout;

class YouTubeNewPlaylistDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit YouTubeNewPlaylistDialog(QWidget *parent = 0);

private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onTitleTextChanged(const QString &text);
    void createPlaylist();
    
signals:
    void playlistCreated(const QVariantMap &playlist);

private:
    QLineEdit *m_titleEdit;
    QTextEdit *m_descriptionEdit;
    QCheckBox *m_privateCheckbox;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
};

#endif // YOUTUBENEWPLAYLISTDIALOG_H
