#ifndef SHARETOTWITTERDIALOG_H
#define SHARETOTWITTERDIALOG_H

#include "abstractdialog.h"
#include "../base/videoitem.h"

class QTextEdit;
class QPushButton;
class QDialogButtonBox;
class QGridLayout;
class QScrollArea;
class QLabel;

class ShareToTwitterDialog : public AbstractDialog
{
    Q_OBJECT

public:
    explicit ShareToTwitterDialog(QSharedPointer<VideoItem> video, QWidget *parent = 0);
    
private:
    void setLandscapeLayout();
    void setPortraitLayout();

private slots:
    void onMessageTextChanged();
    void shareVideo();

private:
    QSharedPointer<VideoItem> m_video;
    QTextEdit *m_messageEdit;
    QLabel *m_charCountLabel;
    QDialogButtonBox *m_buttonBox;
    QPushButton *m_doneButton;
    QScrollArea *m_scrollArea;
    QGridLayout *m_grid;
    QString m_textColor;
};

#endif // SHARETOTWITTERDIALOG_H
