#ifndef VIMEOALBUMLISTMODEL_H
#define VIMEOALBUMLISTMODEL_H

#include "abstractplaylistlistmodel.h"
#include "enums.h"

class VimeoAlbumListModel : public AbstractPlaylistListModel
{
    Q_OBJECT

    Q_PROPERTY(int count
               READ rowCount
               NOTIFY countChanged)
    Q_PROPERTY(bool loading
               READ loading
               NOTIFY loadingChanged)
    Q_PROPERTY(QUrl feed
               READ feed
               WRITE setFeed)

public:
    explicit VimeoAlbumListModel(QObject *parent = 0);
    inline QUrl feed() const { return m_feed; }
    void setFeed(const QUrl &feed);
    inline bool loading() const { return m_loading; }

public slots:
    void clear();
    void reset();
    void getAlbums(QUrl feed = QUrl());
    void getMoreAlbums();

private slots:
    void addAlbums();
    inline void onError() { setError(true); setLoading(false); }

private:
    inline void setLoading(bool loading) { m_loading = loading; emit loadingChanged(loading); }
    inline bool moreResults() const { return m_moreResults; }
    inline void setMoreResults(bool more) { m_moreResults = more; }
    inline int offset() const { return m_offset; }
    inline void setOffset(int offset) { m_offset = offset; }
    inline bool error() const { return m_error; }
    inline void setError(bool error) { m_error = error; }

signals:
    void loadingChanged(bool loading);
    void countChanged(int count);

private:
    QUrl m_feed;
    bool m_loading;
    bool m_moreResults;
    bool m_error;
    int m_offset;
};

#endif // VIMEOALBUMLISTMODEL_H
