#include "unitsettings.h"
#include "ui_unitsettings.h"

UnitSettings::UnitSettings(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::UnitSettings)
{
    ui->setupUi(this);
    connect(ui->listWidget_UnitType, SIGNAL(currentTextChanged(QString)), this, SLOT(updateList(QString)));
    initialSettings();
}

UnitSettings::~UnitSettings()
{
    delete ui;
}

void UnitSettings::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void UnitSettings::initialSettings()
{
    mvUnitType = mvSettings.value("UnitType").toString();
    mvUnit1 = mvSettings.value("Unit1").toString();
    mvUnit2 = mvSettings.value("Unit2").toString();
    QString keyName = "Unit" + mvUnitType + "Name";
    mvSettings.beginGroup(keyName);
    mvUnitName1 = mvSettings.value(mvUnit1).toString();
    mvUnitName2 = mvSettings.value(mvUnit2).toString();
    mvSettings.endGroup();
    keyName = "Unit" + mvUnitType + "Symbol";
    mvSettings.beginGroup(keyName);
    mvUnitSymbol1 = mvSettings.value(mvUnit1).toString();
    mvUnitSymbol2 = mvSettings.value(mvUnit2).toString();
    mvSettings.endGroup();

    updateList(mvUnitType);
    updatePreset();
    updateButtons();
}

void UnitSettings::updateList(QString unitType)
{
    QString keyName = "Unit" + unitType + "Name";
    mvSelectedType = unitType;
    mvSettings.beginGroup(keyName);
    QStringList allUnits = mvSettings.allKeys();
    QString unitName;
    QStringList unitNames;

    mvUnits.clear();

    foreach (QString unit, allUnits) {
        unitName = mvSettings.value(unit).toString();
        unitNames += unitName;        
        mvUnits += unitName;
        mvUnits += unit;
    }
    mvSettings.endGroup();

    ui->listWidget_Unit->clear();
    ui->listWidget_Unit->addItems(unitNames);
    ui->listWidget_Unit->sortItems(Qt::AscendingOrder);


}

void UnitSettings::updatePreset()
{
    mvSettings.beginGroup("UnitPreset");
    QStringList allPresets = mvSettings.allKeys();
    mvSettings.endGroup();
    QString presetValue;
    QString unit1;
    QString unit2;
    QString unitType;
    QString unitName;
    
    mvPresets.clear();

    foreach (QString preset, allPresets) {
        mvSettings.beginGroup("UnitPreset");
        presetValue = mvSettings.value(preset).toString();
        mvSettings.endGroup();
        preset = preset.remove(0, 1);
        if (preset == "Unit1") {
            unit1 = presetValue;
        } else if (preset == "Unit2") {
            unit2 = presetValue;
        } else if (preset == "UnitType") {
            unitType = presetValue;
            mvSettings.beginGroup("Unit" + unitType + "Name");
            unitName = mvSettings.value(unit1).toString();
            unitName += " - ";
            unitName += mvSettings.value(unit2).toString();
            mvSettings.endGroup();
            mvPresets += unitName;
            mvPresets += unit1;
            mvPresets += unit2;
            mvPresets += unitType;
        }
    }

    updatePresetList();
}

void UnitSettings::updatePresetList()
{
    QStringList presetNames;

    for (int index = 0; index < mvPresets.size(); index += 4) {
        presetNames += mvPresets.at(index);
    }

    ui->listWidget_Preset->clear();
    ui->listWidget_Preset->addItems(presetNames);
}

void UnitSettings::unitKey(int whichUnit)
{
    if (ui->listWidget_Unit->currentRow() != -1) {
        QString unitName = ui->listWidget_Unit->currentItem()->text();
        int keyIndex = mvUnits.indexOf(unitName) + 1;
        QString unitKey =  mvUnits.at(keyIndex);
        QString symbolKey = "Unit" + mvSelectedType + "Symbol/" + unitKey;
        QString unitSymbol = mvSettings.value(symbolKey).toString();

        if (whichUnit == 1) {
            mvUnit1 = unitKey;
            mvUnitName1 = unitName;
            mvUnitSymbol1 = unitSymbol;
            if (mvSelectedType != mvUnitType) {
                mvUnit2 = unitKey;
                mvUnitName2 = unitName;
                mvUnitType = mvSelectedType;
                mvUnitSymbol2 = unitSymbol;
            }
        } else if (whichUnit == 2) {
            mvUnit2 = unitKey;
            mvUnitName2 = unitName;
            mvUnitSymbol2 = unitSymbol;
            if (mvSelectedType != mvUnitType) {
                mvUnit1 = unitKey;
                mvUnitName1 = unitName;
                mvUnitType = mvSelectedType;
                mvUnitSymbol1 = unitSymbol;
            }
        }
        updateButtons();
    }
}

void UnitSettings::updateButtons()
{
    ui->pushButton_Unit1->setText(mvUnitSymbol1);
    ui->pushButton_Unit2->setText(mvUnitSymbol2);
}

void UnitSettings::on_pushButton_Unit1_clicked()
{
    unitKey(1);
}

void UnitSettings::on_pushButton_Unit2_clicked()
{
    unitKey(2);
}

void UnitSettings::on_pushButton_Preset_clicked()
{
    mvPresets += mvUnitName1 + " - " + mvUnitName2;
    mvPresets += mvUnit1;
    mvPresets += mvUnit2;
    mvPresets += mvUnitType;
    updatePresetList();
}

void UnitSettings::on_pushButton_Delete_clicked()
{
    if (ui->listWidget_Preset->currentRow() != -1) {
        int index = mvPresets.indexOf(ui->listWidget_Preset->currentItem()->text());
        if (mvPresets.size() > 4) {
            mvPresets.removeAt(index + 3);
            mvPresets.removeAt(index + 2);
            mvPresets.removeAt(index + 1);
            mvPresets.removeAt(index);
            updatePresetList();
        }
    }
}

void UnitSettings::on_pushButton_Apply_clicked()
{
    mvSettings.setValue("UnitType", mvUnitType);
    mvSettings.setValue("Unit1", mvUnit1);
    mvSettings.setValue("Unit2", mvUnit2);


    int countPreset = mvPresets.size();
    int keyIndex = 0;
    QString keyUnit1;
    QString keyUnit2;
    QString keyUnitType;

    mvSettings.remove("UnitPreset");
    mvSettings.beginGroup("UnitPreset");
    for (int index = 0; index < countPreset; index += 4) {
        keyUnit1 = QString::number(keyIndex) + "Unit1";
        keyUnit2 = QString::number(keyIndex) + "Unit2";
        keyUnitType = QString::number(keyIndex) + "UnitType";
        mvSettings.setValue(keyUnit1, mvPresets.at(index + 1));
        mvSettings.setValue(keyUnit2, mvPresets.at(index + 2));
        mvSettings.setValue(keyUnitType, mvPresets.at(index + 3));
        keyIndex += 1;
    }
    mvSettings.endGroup();
    mvSettings.setValue("UnitPreset", keyIndex);
    mvSettings.setValue("Currency", false);
    mvSettings.sync();
    this->close();
}

void UnitSettings::on_actionHelp_triggered()
{
    mvSettings.setValue("Help", "UnitSettings");
    helpWindow = new Help(this);    
    helpWindow->show();
}
